/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.XtextResourceSet;

public class ResourceSetsByClassloaderContext {
    private final Map<Object, XtextResourceSet> resourceSets = Maps.newHashMap();

    public static XtextResourceSet get(ResourceSet rs, Object context) {
        XtextResourceSet xrs;
        if (rs instanceof XtextResourceSet && context.equals((xrs = (XtextResourceSet)rs).getClasspathURIContext())) {
            return xrs;
        }
        ResourceSetsByClassloaderContext contexts = ResourceSetsByClassloaderContext.getOrCreateAdapter(rs);
        XtextResourceSet result = contexts.getOrCreateResourceSet(context);
        return result;
    }

    private static ResourceSetsByClassloaderContext getOrCreateAdapter(ResourceSet rs) {
        XtextResourceSet xrs;
        Object context;
        ResourceSetsByClassloaderContext x;
        EList adapters = rs.eAdapters();
        for (Adapter a : adapters) {
            if (!(a instanceof Ref)) continue;
            return ((Ref)a).getManager();
        }
        ResourceSetsByClassloaderContext resourceSetsByClassloaderContext = x = new ResourceSetsByClassloaderContext();
        resourceSetsByClassloaderContext.getClass();
        adapters.add((Object)resourceSetsByClassloaderContext.new Ref());
        if (rs instanceof XtextResourceSet && (context = (xrs = (XtextResourceSet)rs).getClasspathURIContext()) != null) {
            x.resourceSets.put(context, xrs);
        }
        return x;
    }

    private XtextResourceSet createResourceSet(Object context) {
        XtextResourceSet result = new XtextResourceSet();
        result.eAdapters().add((Object)new Ref());
        this.resourceSets.put(context, result);
        result.setClasspathURIContext(context);
        return result;
    }

    private XtextResourceSet getOrCreateResourceSet(Object context) {
        XtextResourceSet result = this.resourceSets.get(context);
        if (result == null) {
            result = this.createResourceSet(context);
        }
        return result;
    }

    private class Ref
    extends AdapterImpl {
        private Ref() {
        }

        public ResourceSetsByClassloaderContext getManager() {
            return ResourceSetsByClassloaderContext.this;
        }
    }
}

