/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.refactoring;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.n4js.ts.types.util.TypeModelUtils;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIConverter;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRenamedElementTracker;
import org.eclipse.xtext.ui.refactoring.impl.CachingResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.ui.DefaultLinkedPositionGroupCalculator;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.Strings;

public class N4JSLinkedPositionGroupCalculator
extends DefaultLinkedPositionGroupCalculator {
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;
    @Inject
    private IRenamedElementTracker renamedElementTracker;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private IReferenceUpdater referenceUpdater;
    @Inject
    private TargetURIConverter targetURIConverter;
    @Inject
    private Provider<DefaultLinkedPositionGroupCalculator.LocalResourceRefactoringUpdateAcceptor> updateAcceptorProvider;

    public Provider<LinkedPositionGroup> getLinkedPositionGroup(IRenameElementContext renameElementContext, IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final XtextEditor editor = (XtextEditor)renameElementContext.getTriggeringEditor();
        IProject project = this.projectUtil.getProject(renameElementContext.getContextResourceURI());
        if (project == null) {
            throw new IllegalStateException("Could not determine project for context resource " + renameElementContext.getContextResourceURI());
        }
        CachingResourceSetProvider resourceSetProvider = new CachingResourceSetProvider(this.resourceSetProvider);
        ResourceSet resourceSet = resourceSetProvider.get(project);
        EObject targetElement = resourceSet.getEObject(renameElementContext.getTargetElementURI(), true);
        if (targetElement == null) {
            throw new IllegalStateException("Target element could not be loaded");
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        List realTargetElements = TypeModelUtils.getRealElements((EObject)targetElement);
        DefaultLinkedPositionGroupCalculator.LocalResourceRefactoringUpdateAcceptor updateAcceptor = (DefaultLinkedPositionGroupCalculator.LocalResourceRefactoringUpdateAcceptor)this.updateAcceptorProvider.get();
        updateAcceptor.setLocalResourceURI(renameElementContext.getContextResourceURI());
        IRenameStrategy renameStrategy2 = null;
        for (EObject realTargetElement : realTargetElements) {
            IRenameStrategy.Provider strategyProvider = (IRenameStrategy.Provider)this.globalServiceProvider.findService(realTargetElement, IRenameStrategy.Provider.class);
            IRenameStrategy renameStrategy = null;
            try {
                renameStrategy = strategyProvider.get(realTargetElement, renameElementContext);
            }
            catch (IRenameStrategy.Provider.NoSuchStrategyException noSuchStrategyException) {
                // empty catch block
            }
            if (renameStrategy == null) {
                throw new IllegalArgumentException("Cannot find a rename strategy for " + Strings.notNull((Object)renameElementContext.getTargetElementURI()));
            }
            renameStrategy2 = renameStrategy;
            String newName = renameStrategy.getOriginalName();
            IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(renameElementContext.getTargetElementURI());
            IDependentElementsCalculator dependentElementsCalculator = (IDependentElementsCalculator)resourceServiceProvider.get(IDependentElementsCalculator.class);
            Iterable dependentElementURIs = dependentElementsCalculator.getDependentElementURIs(realTargetElement, (IProgressMonitor)progress.newChild(10));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            renameStrategy.createDeclarationUpdates(newName, resourceSet, (IRefactoringUpdateAcceptor)updateAcceptor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Iterable renameElems = TypeModelUtils.isComposedTElement((EObject)targetElement) ? dependentElementURIs : Iterables.concat(Collections.singleton(renameElementContext.getTargetElementURI()), (Iterable)dependentElementURIs);
            Map original2newEObjectURI = this.renamedElementTracker.renameAndTrack(renameElems, newName, resourceSet, renameStrategy, (IProgressMonitor)progress.newChild(10));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ElementRenameArguments elementRenameArguments = new ElementRenameArguments(renameElementContext.getTargetElementURI(), newName, renameStrategy, original2newEObjectURI, (RefactoringResourceSetProvider)resourceSetProvider);
            final ArrayList referenceDescriptions = Lists.newArrayList();
            IReferenceFinder.Acceptor referenceAcceptor = new IReferenceFinder.Acceptor(){

                public void accept(IReferenceDescription referenceDescription) {
                    referenceDescriptions.add(referenceDescription);
                }

                public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
                    referenceDescriptions.add(new DefaultReferenceDescription(EcoreUtil2.getFragmentPathURI((EObject)source), targetURI, eReference, index, null));
                }
            };
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.referenceFinder.findReferences((Predicate)this.targetURIConverter.fromIterable(elementRenameArguments.getRenamedElementURIs()), resourceSet.getResource(renameElementContext.getContextResourceURI(), true), referenceAcceptor, (IProgressMonitor)progress.newChild(10));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<Object> referenceDescriptionsWithoutComposedMember = TypeModelUtils.isComposedTElement((EObject)targetElement) ? referenceDescriptions : referenceDescriptions.stream().filter(resDesc -> !TypeModelUtils.isComposedMemberURI((URI)resDesc.getTargetEObjectUri())).collect(Collectors.toList());
            this.referenceUpdater.createReferenceUpdates(elementRenameArguments, (Iterable)referenceDescriptionsWithoutComposedMember, (IRefactoringUpdateAcceptor)updateAcceptor, (IProgressMonitor)progress.newChild(60));
        }
        List textEdits = updateAcceptor.getTextEdits();
        final ArrayList<ReplaceEdit> textEditsWithoutDuplicates = new ArrayList<ReplaceEdit>();
        for (ReplaceEdit edit : textEdits) {
            if (textEditsWithoutDuplicates.stream().filter(e -> e.getOffset() == edit.getOffset() && e.getLength() == edit.getLength()).findFirst().isPresent()) continue;
            textEditsWithoutDuplicates.add(edit);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        final String originalName = renameStrategy2.getOriginalName();
        return new Provider<LinkedPositionGroup>(){

            public LinkedPositionGroup get() {
                LinkedPositionGroup linkedGroup = N4JSLinkedPositionGroupCalculator.this.createLinkedGroupFromReplaceEdits(textEditsWithoutDuplicates, editor, originalName, progress.newChild(10));
                return linkedGroup;
            }
        };
    }
}

