/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.n4js.cli.helper.AbstractCliCompileTest;
import org.eclipse.n4js.cli.helper.ProcessResult;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class CliCompileResult
extends ProcessResult {
    final AbstractCliCompileTest.N4jscVariant n4jscVariant;
    Map<String, String> projects = new LinkedHashMap<String, String>();
    Multimap<String, String> errors = HashMultimap.create();
    Multimap<String, String> warnings = HashMultimap.create();
    TreeMap<Path, HashSet<File>> transpiledFiles = new TreeMap();

    public CliCompileResult() {
        this(AbstractCliCompileTest.N4jscVariant.inprocess);
    }

    public CliCompileResult(AbstractCliCompileTest.N4jscVariant n4jscVariant) {
        this.n4jscVariant = n4jscVariant;
    }

    public AbstractCliCompileTest.N4jscVariant getN4jscVariant() {
        return this.n4jscVariant;
    }

    public int getErrs() {
        return this.getErrMsgs().size();
    }

    public int getWrns() {
        return this.getWrnMsgs().size();
    }

    public Map<String, String> getProjects() {
        return this.projects;
    }

    public Collection<String> getErrFiles() {
        return new TreeSet<String>(this.errors.keySet());
    }

    public Collection<String> getErrMsgs() {
        return new TreeSet<String>(this.errors.values());
    }

    public Collection<String> getWrnFiles() {
        return new TreeSet<String>(this.warnings.keySet());
    }

    public Collection<String> getWrnMsgs() {
        return new TreeSet<String>(this.warnings.values());
    }

    public int getTranspiledFilesCount() {
        return this.getTranspiledFiles().size();
    }

    public int getTranspiledFilesCount(Path dir) {
        return this.getTranspiledFiles(dir).size();
    }

    public Collection<File> getTranspiledFiles() {
        return this.getTranspiledFiles(null);
    }

    public Collection<File> getTranspiledFiles(Path dir) {
        return this.getFiles(dir, true);
    }

    public Collection<String> getTranspiledFileNames() {
        return this.getTranspiledFiles().stream().map(f -> f.toString()).collect(Collectors.toList());
    }

    private Collection<File> getFiles(Path dir, boolean includeSubdirs) {
        if (this.transpiledFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (!includeSubdirs && dir != null) {
            Collection filesInDir = this.transpiledFiles.get(dir);
            return filesInDir;
        }
        Path start = dir == null ? this.transpiledFiles.firstKey() : dir;
        LinkedList<File> filesInDir = new LinkedList<File>();
        SortedMap<Path, HashSet<File>> tailMap = this.transpiledFiles.tailMap(start);
        for (Map.Entry next : tailMap.entrySet()) {
            Path curDir = (Path)next.getKey();
            if (dir != null && !curDir.startsWith(dir)) break;
            filesInDir.addAll((Collection)next.getValue());
        }
        return filesInDir;
    }

    @Override
    List<Pair<String, String>> getProperties() {
        List<Pair<String, String>> props = super.getProperties();
        List fileNameList = this.getTranspiledFiles().stream().map(f -> f.toString()).collect(Collectors.toList());
        props.add((Pair<String, String>)Tuples.pair((Object)("transpiled (" + this.getTranspiledFilesCount() + ")"), (Object)""));
        if (this.getTranspiledFilesCount() > 0) {
            props.add((Pair<String, String>)Tuples.pair(null, (Object)("      " + String.join((CharSequence)"\n      ", fileNameList) + "\n")));
        }
        if (this.n4jscVariant == AbstractCliCompileTest.N4jscVariant.exprocess) {
            return props;
        }
        List projectNameList = this.getProjects().entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + " at " + (String)e.getValue()).collect(Collectors.toList());
        props.add((Pair<String, String>)Tuples.pair((Object)"variant", (Object)this.n4jscVariant.toString()));
        props.add((Pair<String, String>)Tuples.pair((Object)("projects (" + this.getProjects().size() + ")"), (Object)""));
        if (this.getProjects().size() > 0) {
            props.add((Pair<String, String>)Tuples.pair(null, (Object)("      " + String.join((CharSequence)"\n      ", projectNameList))));
        }
        props.add((Pair<String, String>)Tuples.pair((Object)("warnings (" + this.getWrns() + ")"), (Object)""));
        if (this.getWrns() > 0) {
            props.add((Pair<String, String>)Tuples.pair(null, (Object)("   " + String.join((CharSequence)"\n   ", this.getWrnMsgs()))));
        }
        props.add((Pair<String, String>)Tuples.pair((Object)("errors (" + this.getErrs() + ")"), (Object)""));
        if (this.getErrs() > 0) {
            props.add((Pair<String, String>)Tuples.pair(null, (Object)("   " + String.join((CharSequence)"\n   ", this.getErrMsgs()))));
        }
        return props;
    }
}

