/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.builder;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.n4js.ui.external.ExternalLibraryBuildScheduler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.xtext.builder.impl.ProjectOpenedOrClosedListener;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.ui.testing.util.TestedWorkspace;
import org.eclipse.xtext.util.Exceptions;
import org.junit.Assert;
import org.junit.runner.Description;

public class TestedN4JSWorkspace
extends TestedWorkspace {
    @Inject
    private ExternalLibraryBuildScheduler externalLibraryBuildJobProvider;
    private String name;

    @Inject
    public TestedN4JSWorkspace(ISharedStateContributionRegistry contributions) {
        this((ProjectOpenedOrClosedListener)contributions.getSingleContributedInstance(ProjectOpenedOrClosedListener.class));
    }

    public TestedN4JSWorkspace(ProjectOpenedOrClosedListener closedProjectTaskProcessor) {
        super(closedProjectTaskProcessor);
    }

    public void joinJobsBeforeBuild() {
        super.joinJobsBeforeBuild();
        this.externalLibraryBuildJobProvider.joinBuildJob();
    }

    protected void starting(Description d) {
        IIntroManager introManager;
        this.name = d.getMethodName();
        this.assertEmptyIndex();
        IProject[] projects = IResourcesSetupUtil.root().getProjects();
        if (projects.length != 0) {
            Assert.assertEquals((long)1L, (long)projects.length);
            Assert.assertEquals((Object)"RemoteSystemsTempFiles", (Object)projects[0].getName());
        }
        if (PlatformUI.isWorkbenchRunning() && (introManager = PlatformUI.getWorkbench().getIntroManager()).getIntro() != null) {
            Display.getDefault().asyncExec(() -> {
                boolean bl = introManager.closeIntro(introManager.getIntro());
            });
        }
    }

    public void deleteAllProjects() {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IProject[] visibleProjects = TestedN4JSWorkspace.this.root().getProjects();
                    this.deleteProjects(visibleProjects);
                    IProject[] hiddenProjects = TestedN4JSWorkspace.this.root().getProjects(8);
                    this.deleteProjects(hiddenProjects);
                }

                private void deleteProjects(IProject[] projects) {
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        if (!"RemoteSystemsTempFiles".equals(project.getName()) && project.exists()) {
                            try {
                                project.delete(true, true, TestedN4JSWorkspace.this.monitor());
                            }
                            catch (CoreException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        ++n2;
                    }
                }
            }.run(this.monitor());
        }
        catch (InvocationTargetException e) {
            Exceptions.throwUncheckedException((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public String getTestName() {
        return this.name;
    }
}

