/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class AdviceFileParser {
    private static final String ADVICE_VERSION = "advice.version";
    private static final String QUALIFIER_SUBSTITUTION = "$qualifier$";
    private static final String VERSION_SUBSTITUTION = "$version$";
    private static final String UPDATE_DESCRIPTION = "update.description";
    private static final String UPDATE_SEVERITY = "update.severity";
    private static final String UPDATE_RANGE = "update.range";
    private static final String UPDATE_ID = "update.id";
    private static final String UPDATE_MATCH_EXP = "update.matchExp";
    private static final String CLASSIFIER = "classifier";
    private static final String TOUCHPOINT_VERSION = "touchpoint.version";
    private static final String TOUCHPOINT_ID = "touchpoint.id";
    private static final String COPYRIGHT_LOCATION = "copyright.location";
    private static final String COPYRIGHT = "copyright";
    private static final String ID = "id";
    private static final String SINGLETON = "singleton";
    private static final String IMPORT = "import";
    private static final String RANGE = "range";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String FILTER = "filter";
    private static final String MULTIPLE = "multiple";
    private static final String OPTIONAL = "optional";
    private static final String GREEDY = "greedy";
    private static final String VERSION = "version";
    private static final String NAMESPACE = "namespace";
    private static final String NAME = "name";
    private static final String MATCH_EXP = "matchExp";
    private static final String LOCATION = "location";
    private static final String VALUE = "value";
    private static final String UNITS_PREFIX = "units.";
    private static final String INSTRUCTIONS_PREFIX = "instructions.";
    private static final String REQUIRES_PREFIX = "requires.";
    private static final String META_REQUIREMENTS_PREFIX = "metaRequirements.";
    private static final String PROVIDES_PREFIX = "provides.";
    private static final String PROPERTIES_PREFIX = "properties.";
    private static final String LICENSES_PREFIX = "licenses.";
    private static final String ARTIFACTS_PREFIX = "artifacts.";
    private static final String HOST_REQUIREMENTS_PREFIX = "hostRequirements.";
    private static final String UPDATE_DESCRIPTOR_PREFIX = "update.";
    public static final Version COMPATIBLE_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    public static final VersionRange VERSION_TOLERANCE = new VersionRange(COMPATIBLE_VERSION, true, Version.createOSGi((int)2, (int)0, (int)0), false);
    private Map<String, String> adviceProperties = new HashMap<String, String>();
    private List<IProvidedCapability> adviceProvides = new ArrayList<IProvidedCapability>();
    private List<IRequirement> adviceRequires = new ArrayList<IRequirement>();
    private List<IRequirement> adviceMetaRequires = new ArrayList<IRequirement>();
    private IUpdateDescriptor adviceUpdateDescriptor = null;
    private Map<String, ITouchpointInstruction> adviceInstructions = new HashMap<String, ITouchpointInstruction>();
    private List<MetadataFactory.InstallableUnitDescription> adviceOtherIUs = new ArrayList<MetadataFactory.InstallableUnitDescription>();
    private final Map<String, String> advice;
    private Iterator<String> keysIterator;
    private String current;
    private String hostId;
    private Version hostVersion;

    public AdviceFileParser(String id, Version version, Map<String, String> advice) {
        this.hostId = id;
        this.hostVersion = version;
        this.advice = advice;
    }

    public void parse() {
        String adviceVersion = this.advice.get(ADVICE_VERSION);
        if (adviceVersion != null) {
            this.checkAdviceVersion(adviceVersion);
        }
        ArrayList<String> keys = new ArrayList<String>(this.advice.keySet());
        Collections.sort(keys);
        this.keysIterator = keys.iterator();
        this.next();
        while (this.current != null) {
            if (this.current.startsWith(PROPERTIES_PREFIX)) {
                this.parseProperties(PROPERTIES_PREFIX, this.adviceProperties);
                continue;
            }
            if (this.current.startsWith(UPDATE_DESCRIPTOR_PREFIX)) {
                this.adviceUpdateDescriptor = this.parseUpdateDescriptor(UPDATE_DESCRIPTOR_PREFIX, this.hostId);
                continue;
            }
            if (this.current.startsWith(PROVIDES_PREFIX)) {
                this.parseProvides(PROVIDES_PREFIX, this.adviceProvides);
                continue;
            }
            if (this.current.startsWith(REQUIRES_PREFIX)) {
                this.parseRequires(REQUIRES_PREFIX, this.adviceRequires);
                continue;
            }
            if (this.current.startsWith(META_REQUIREMENTS_PREFIX)) {
                this.parseRequires(META_REQUIREMENTS_PREFIX, this.adviceMetaRequires);
                continue;
            }
            if (this.current.startsWith(INSTRUCTIONS_PREFIX)) {
                this.parseInstructions(INSTRUCTIONS_PREFIX, this.adviceInstructions);
                continue;
            }
            if (this.current.startsWith(UNITS_PREFIX)) {
                this.parseUnits(UNITS_PREFIX, this.adviceOtherIUs);
                continue;
            }
            if (this.current.equals(ADVICE_VERSION)) {
                this.next();
                continue;
            }
            this.next();
        }
    }

    private void checkAdviceVersion(String adviceVersion) {
        Version version = Version.parseVersion((String)adviceVersion);
        if (!VERSION_TOLERANCE.isIncluded(version)) {
            throw new IllegalStateException("bad version: " + version + ". Expected range was " + VERSION_TOLERANCE);
        }
    }

    private void next() {
        this.current = this.keysIterator.hasNext() ? this.keysIterator.next() : null;
    }

    private String currentValue() {
        return this.advice.get(this.current).trim();
    }

    private void parseProperties(String prefix, Map<String, String> properties) {
        while (this.current != null && this.current.startsWith(prefix)) {
            int dotIndex = this.current.indexOf(46, prefix.length());
            if (dotIndex == -1) {
                throw new IllegalStateException("bad token: " + this.current);
            }
            this.parseProperty(this.current.substring(0, dotIndex + 1), properties);
        }
    }

    private void parseProperty(String prefix, Map<String, String> properties) {
        String propertyName = null;
        String propertyValue = null;
        while (this.current != null && this.current.startsWith(prefix)) {
            String token;
            switch (token = this.current.substring(prefix.length())) {
                case "name": {
                    propertyName = this.currentValue();
                    break;
                }
                case "value": {
                    propertyValue = this.currentValue();
                    break;
                }
            }
            this.next();
        }
        properties.put(propertyName, propertyValue);
    }

    private IUpdateDescriptor parseUpdateDescriptor(String prefix, String id) {
        String name = id;
        String description = null;
        String range = "[0.0.0,$version$)";
        String severity = "0";
        String match = null;
        while (this.current != null && this.current.startsWith(prefix)) {
            String token;
            switch (token = this.current) {
                case "update.matchExp": {
                    match = this.currentValue();
                    break;
                }
                case "update.id": {
                    name = this.currentValue();
                    break;
                }
                case "update.description": {
                    description = this.currentValue();
                    break;
                }
                case "update.range": {
                    range = this.currentValue();
                    break;
                }
                case "update.severity": {
                    severity = this.currentValue();
                    break;
                }
            }
            this.next();
        }
        if (match != null) {
            IExpression expr = ExpressionUtil.parse((String)this.substituteVersionAndQualifier(match));
            IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(expr, new Object[0]);
            ArrayList<IMatchExpression> descriptors = new ArrayList<IMatchExpression>(1);
            descriptors.add(matchExpression);
            return MetadataFactory.createUpdateDescriptor(descriptors, (int)Integer.valueOf(severity), (String)description, null);
        }
        range = this.substituteVersionAndQualifier(range);
        VersionRange versionRange = VersionRange.create((String)range);
        return MetadataFactory.createUpdateDescriptor((String)name, (VersionRange)versionRange, (int)Integer.valueOf(severity), description);
    }

    private void parseProvides(String prefix, List<IProvidedCapability> provides) {
        while (this.current != null && this.current.startsWith(prefix)) {
            int dotIndex = this.current.indexOf(46, prefix.length());
            if (dotIndex == -1) {
                throw new IllegalStateException("bad token: " + this.current);
            }
            this.parseProvided(this.current.substring(0, dotIndex + 1), provides);
        }
    }

    private void parseProvided(String prefix, List<IProvidedCapability> provides) {
        String namespace = null;
        String name = null;
        Version capabilityVersion = null;
        while (this.current != null && this.current.startsWith(prefix)) {
            String token;
            switch (token = this.current.substring(prefix.length())) {
                case "name": {
                    name = this.currentValue();
                    break;
                }
                case "namespace": {
                    namespace = this.currentValue();
                    break;
                }
                case "version": {
                    capabilityVersion = Version.parseVersion((String)this.substituteVersionAndQualifier(this.currentValue()));
                    break;
                }
            }
            this.next();
        }
        IProvidedCapability capability = MetadataFactory.createProvidedCapability(namespace, name, capabilityVersion);
        provides.add(capability);
    }

    private void parseRequires(String prefix, List<IRequirement> requires) {
        while (this.current != null && this.current.startsWith(prefix)) {
            int dotIndex = this.current.indexOf(46, prefix.length());
            if (dotIndex == -1) {
                throw new IllegalStateException("bad token: " + this.current);
            }
            this.parseRequired(this.current.substring(0, dotIndex + 1), requires);
        }
    }

    private void parseRequired(String prefix, List<IRequirement> requires) {
        String namespace = null;
        String name = null;
        VersionRange range = null;
        String matchExp = null;
        String filter = null;
        boolean optional = false;
        boolean multiple = false;
        boolean greedy = true;
        int min = -1;
        int max = -1;
        while (this.current != null && this.current.startsWith(prefix)) {
            String token;
            switch (token = this.current.substring(prefix.length())) {
                case "greedy": {
                    greedy = Boolean.parseBoolean(this.currentValue());
                    break;
                }
                case "optional": {
                    optional = Boolean.parseBoolean(this.currentValue());
                    break;
                }
                case "multiple": {
                    multiple = Boolean.parseBoolean(this.currentValue());
                    break;
                }
                case "filter": {
                    filter = this.currentValue();
                    break;
                }
                case "name": {
                    name = this.currentValue();
                    break;
                }
                case "namespace": {
                    namespace = this.currentValue();
                    break;
                }
                case "range": {
                    range = VersionRange.create((String)this.substituteVersionAndQualifier(this.currentValue()));
                    break;
                }
                case "min": {
                    min = Integer.valueOf(this.currentValue());
                    break;
                }
                case "max": {
                    max = Integer.valueOf(this.currentValue());
                    break;
                }
                case "matchExp": {
                    matchExp = this.currentValue();
                    break;
                }
            }
            this.next();
        }
        IRequirement capability = null;
        if (matchExp == null) {
            capability = min >= 0 && max >= 0 ? this.createRequirement(namespace, name, range, filter, min, max, greedy) : this.createRequirement(namespace, name, range, filter, optional, multiple, greedy);
        } else {
            if (optional && min == -1 && max == -1) {
                min = 0;
                max = 1;
            }
            capability = this.createRequirement(matchExp, filter, min, max, greedy, null);
        }
        if (capability != null) {
            requires.add(capability);
        }
    }

    protected IRequirement createRequirement(String requirement, String filter, int min, int max, boolean greedy, String description) {
        IExpression expr = ExpressionUtil.parse((String)this.substituteVersionAndQualifier(requirement));
        IMatchExpression requirementExp = ExpressionUtil.getFactory().matchExpression(expr, new Object[0]);
        IMatchExpression filterExp = InstallableUnit.parseFilter((String)filter);
        return MetadataFactory.createRequirement((IMatchExpression)requirementExp, (IMatchExpression)filterExp, (int)min, (int)max, (boolean)greedy, (String)description);
    }

    protected IRequirement createRequirement(String namespace, String name, VersionRange range, String filter, int min, int max, boolean greedy) {
        IMatchExpression filterExpression = InstallableUnit.parseFilter((String)filter);
        return MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, (IMatchExpression)filterExpression, (int)min, (int)max, (boolean)greedy);
    }

    protected IRequirement createRequirement(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
        return MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, (String)filter, (boolean)optional, (boolean)multiple, (boolean)greedy);
    }

    private void parseInstructions(String prefix, Map<String, ITouchpointInstruction> instructions) {
        while (this.current != null && this.current.startsWith(prefix)) {
            int dotIndex = this.current.indexOf(46, prefix.length());
            if (dotIndex != -1) {
                throw new IllegalStateException("bad token: " + this.current);
            }
            this.parseInstruction(this.current, instructions);
        }
    }

    private void parseInstruction(String prefix, Map<String, ITouchpointInstruction> instructions) {
        String phase = this.current.substring(this.current.lastIndexOf(46) + 1);
        String body = this.currentValue();
        this.next();
        prefix = String.valueOf(prefix) + '.';
        String importAttribute = null;
        if (this.current != null && this.current.startsWith(prefix)) {
            if (this.current.substring(prefix.length()).equals(IMPORT)) {
                importAttribute = this.currentValue();
            }
            this.next();
        }
        ITouchpointInstruction instruction = MetadataFactory.createTouchpointInstruction((String)body, importAttribute);
        instructions.put(phase, instruction);
    }

    private void parseUnits(String prefix, List<MetadataFactory.InstallableUnitDescription> ius) {
        while (this.current != null && this.current.startsWith(prefix)) {
            int dotIndex = this.current.indexOf(46, prefix.length());
            if (dotIndex == -1) {
                throw new IllegalStateException("bad token: " + this.current + " = " + this.currentValue());
            }
            this.parseUnit(this.current.substring(0, dotIndex + 1), ius);
        }
    }

    private void parseUnit(String prefix, List<MetadataFactory.InstallableUnitDescription> units) {
        String unitId = null;
        Version unitVersion = null;
        boolean unitSingleton = false;
        String unitFilter = null;
        String unitCopyright = null;
        String unitCopyrightLocation = null;
        String unitTouchpointId = null;
        Version unitTouchpointVersion = null;
        String unitUpdateId = null;
        VersionRange unitUpdateRange = null;
        int unitUpdateSeverity = 0;
        String unitUpdateDescription = null;
        ArrayList<IArtifactKey> unitArtifacts = new ArrayList<IArtifactKey>();
        HashMap<String, String> unitProperties = new HashMap<String, String>();
        ArrayList<IRequirement> unitHostRequirements = new ArrayList<IRequirement>();
        ArrayList<IProvidedCapability> unitProvides = new ArrayList<IProvidedCapability>();
        ArrayList<IRequirement> unitRequires = new ArrayList<IRequirement>();
        ArrayList<IRequirement> unitMetaRequirements = new ArrayList<IRequirement>();
        ArrayList<ILicense> unitLicenses = new ArrayList<ILicense>();
        HashMap<String, ITouchpointInstruction> unitInstructions = new HashMap<String, ITouchpointInstruction>();
        while (this.current != null && this.current.startsWith(prefix)) {
            String token = this.current.substring(prefix.length());
            if (token.equals(ID)) {
                unitId = this.currentValue();
                this.next();
                continue;
            }
            if (token.equals(VERSION)) {
                unitVersion = Version.parseVersion((String)this.substituteVersionAndQualifier(this.currentValue()));
                this.next();
                continue;
            }
            if (token.equals(SINGLETON)) {
                unitSingleton = Boolean.parseBoolean(this.currentValue());
                this.next();
                continue;
            }
            if (token.equals(FILTER)) {
                unitFilter = this.currentValue();
                this.next();
                continue;
            }
            if (token.equals(COPYRIGHT)) {
                unitCopyright = this.currentValue();
                this.next();
                continue;
            }
            if (token.equals(COPYRIGHT_LOCATION)) {
                unitCopyrightLocation = this.currentValue();
                this.next();
                continue;
            }
            if (token.equals(TOUCHPOINT_ID)) {
                unitTouchpointId = this.currentValue();
                this.next();
                continue;
            }
            if (token.equals(TOUCHPOINT_VERSION)) {
                unitTouchpointVersion = Version.parseVersion((String)this.substituteVersionAndQualifier(this.currentValue()));
                this.next();
                continue;
            }
            if (token.equals(UPDATE_ID)) {
                unitUpdateId = this.currentValue();
                this.next();
                continue;
            }
            if (token.equals(UPDATE_RANGE)) {
                unitUpdateRange = VersionRange.create((String)this.substituteVersionAndQualifier(this.currentValue()));
                this.next();
                continue;
            }
            if (token.equals(UPDATE_SEVERITY)) {
                unitUpdateSeverity = Integer.parseInt(this.currentValue());
                this.next();
                continue;
            }
            if (token.equals(UPDATE_DESCRIPTION)) {
                unitUpdateDescription = this.currentValue();
                this.next();
                continue;
            }
            if (token.startsWith(HOST_REQUIREMENTS_PREFIX)) {
                this.parseRequires(String.valueOf(prefix) + HOST_REQUIREMENTS_PREFIX, unitHostRequirements);
                continue;
            }
            if (token.startsWith(ARTIFACTS_PREFIX)) {
                this.parseArtifacts(String.valueOf(prefix) + ARTIFACTS_PREFIX, unitArtifacts);
                continue;
            }
            if (token.startsWith(LICENSES_PREFIX)) {
                this.parseLicenses(String.valueOf(prefix) + LICENSES_PREFIX, unitLicenses);
                continue;
            }
            if (token.startsWith(PROPERTIES_PREFIX)) {
                this.parseProperties(String.valueOf(prefix) + PROPERTIES_PREFIX, unitProperties);
                continue;
            }
            if (token.startsWith(PROVIDES_PREFIX)) {
                this.parseProvides(String.valueOf(prefix) + PROVIDES_PREFIX, unitProvides);
                continue;
            }
            if (token.startsWith(REQUIRES_PREFIX)) {
                this.parseRequires(String.valueOf(prefix) + REQUIRES_PREFIX, unitRequires);
                continue;
            }
            if (token.startsWith(META_REQUIREMENTS_PREFIX)) {
                this.parseRequires(String.valueOf(prefix) + META_REQUIREMENTS_PREFIX, unitMetaRequirements);
                continue;
            }
            if (token.startsWith(INSTRUCTIONS_PREFIX)) {
                this.parseInstructions(String.valueOf(prefix) + INSTRUCTIONS_PREFIX, unitInstructions);
                continue;
            }
            this.next();
        }
        MetadataFactory.InstallableUnitDescription description = unitHostRequirements.isEmpty() ? new MetadataFactory.InstallableUnitDescription() : new MetadataFactory.InstallableUnitFragmentDescription();
        description.setId(unitId);
        description.setVersion(unitVersion);
        description.setSingleton(unitSingleton);
        description.setFilter(unitFilter);
        if (unitCopyright != null || unitCopyrightLocation != null) {
            try {
                URI uri = unitCopyrightLocation != null ? new URI(unitCopyrightLocation) : null;
                description.setCopyright(MetadataFactory.createCopyright((URI)uri, unitCopyright));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalStateException("bad copyright URI at token: " + this.current + ", " + this.currentValue());
            }
        }
        if (unitTouchpointId != null) {
            description.setTouchpointType(MetadataFactory.createTouchpointType(unitTouchpointId, unitTouchpointVersion));
        }
        if (unitUpdateId != null) {
            description.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor(unitUpdateId, unitUpdateRange, (int)unitUpdateSeverity, unitUpdateDescription));
        }
        if (!unitLicenses.isEmpty()) {
            description.setLicenses(unitLicenses.toArray(new ILicense[unitLicenses.size()]));
        }
        if (!unitArtifacts.isEmpty()) {
            description.setArtifacts(unitArtifacts.toArray(new IArtifactKey[unitArtifacts.size()]));
        }
        if (!unitHostRequirements.isEmpty()) {
            ((MetadataFactory.InstallableUnitFragmentDescription)description).setHost(unitHostRequirements.toArray(new IRequirement[unitHostRequirements.size()]));
        }
        if (!unitProperties.isEmpty()) {
            for (Map.Entry entry : unitProperties.entrySet()) {
                description.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!unitProvides.isEmpty()) {
            description.setCapabilities(unitProvides.toArray(new IProvidedCapability[unitProvides.size()]));
        }
        if (!unitRequires.isEmpty()) {
            description.setRequirements(unitRequires.toArray(new IRequirement[unitRequires.size()]));
        }
        if (!unitMetaRequirements.isEmpty()) {
            description.setMetaRequirements(unitMetaRequirements.toArray(new IRequirement[unitMetaRequirements.size()]));
        }
        if (!unitInstructions.isEmpty()) {
            description.addTouchpointData(MetadataFactory.createTouchpointData(unitInstructions));
        }
        this.adviceOtherIUs.add(description);
    }

    private void parseLicenses(String prefix, List<ILicense> licenses) {
        while (this.current != null && this.current.startsWith(prefix)) {
            int dotIndex = this.current.indexOf(46, prefix.length());
            if (dotIndex != -1) {
                throw new IllegalStateException("bad token: " + this.current + " = " + this.currentValue());
            }
            this.parseLicense(this.current, licenses);
        }
    }

    private void parseLicense(String prefix, List<ILicense> licenses) {
        String body = this.currentValue();
        this.next();
        prefix = String.valueOf(prefix) + '.';
        String location = null;
        if (this.current != null && this.current.startsWith(prefix)) {
            if (this.current.substring(prefix.length()).equals(LOCATION)) {
                location = this.currentValue();
            }
            this.next();
        }
        try {
            URI uri = location != null ? new URI(location) : null;
            ILicense license = MetadataFactory.createLicense((URI)uri, (String)body);
            licenses.add(license);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("bad license URI at token: " + this.current + ", " + this.currentValue());
        }
    }

    private void parseArtifacts(String prefix, List<IArtifactKey> artifacts) {
        while (this.current != null && this.current.startsWith(prefix)) {
            int dotIndex = this.current.indexOf(46, prefix.length());
            if (dotIndex == -1) {
                throw new IllegalStateException("bad token: " + this.current + " = " + this.currentValue());
            }
            this.parseArtifact(this.current.substring(0, dotIndex + 1), artifacts);
        }
    }

    private void parseArtifact(String prefix, List<IArtifactKey> artifacts) {
        String artifactClassifier = null;
        String artifactId = null;
        Version artifactVersion = null;
        while (this.current != null && this.current.startsWith(prefix)) {
            String token;
            switch (token = this.current.substring(prefix.length())) {
                case "classifier": {
                    artifactClassifier = this.currentValue();
                    break;
                }
                case "id": {
                    artifactId = this.currentValue();
                    break;
                }
                case "version": {
                    artifactVersion = Version.parseVersion((String)this.substituteVersionAndQualifier(this.currentValue()));
                    break;
                }
            }
            this.next();
        }
        ArtifactKey artifactKey = new ArtifactKey(artifactClassifier, artifactId, artifactVersion);
        artifacts.add((IArtifactKey)artifactKey);
    }

    private String substituteVersionAndQualifier(String version) {
        if (version.contains(VERSION_SUBSTITUTION)) {
            version = AdviceFileParser.replace(version, VERSION_SUBSTITUTION, this.hostVersion.toString());
        }
        if (version.contains(QUALIFIER_SUBSTITUTION)) {
            try {
                String qualifier = PublisherHelper.toOSGiVersion(this.hostVersion).getQualifier();
                if (qualifier == null) {
                    qualifier = "";
                }
                if (qualifier.length() == 0) {
                    version = AdviceFileParser.replace(version, ".$qualifier$", "");
                }
                version = AdviceFileParser.replace(version, QUALIFIER_SUBSTITUTION, qualifier);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return version;
    }

    public static String replace(String source, String from, String to) {
        if (from.length() == 0) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int current = 0;
        int pos = 0;
        while (pos != -1) {
            pos = source.indexOf(from, current);
            if (pos == -1) {
                buffer.append(source.substring(current));
                continue;
            }
            buffer.append(source.substring(current, pos));
            buffer.append(to);
            current = pos + from.length();
        }
        return buffer.toString();
    }

    public Map<String, String> getProperties() {
        if (this.adviceProperties.isEmpty()) {
            return null;
        }
        return this.adviceProperties;
    }

    public IRequirement[] getRequiredCapabilities() {
        if (this.adviceRequires.isEmpty()) {
            return null;
        }
        return this.adviceRequires.toArray(new IRequirement[this.adviceRequires.size()]);
    }

    public IProvidedCapability[] getProvidedCapabilities() {
        if (this.adviceProvides.isEmpty()) {
            return null;
        }
        return this.adviceProvides.toArray(new IProvidedCapability[this.adviceProvides.size()]);
    }

    public IUpdateDescriptor getUpdateDescriptor() {
        return this.adviceUpdateDescriptor;
    }

    public Map<String, ITouchpointInstruction> getTouchpointInstructions() {
        if (this.adviceInstructions.isEmpty()) {
            return null;
        }
        return this.adviceInstructions;
    }

    public MetadataFactory.InstallableUnitDescription[] getAdditionalInstallableUnitDescriptions() {
        if (this.adviceOtherIUs.isEmpty()) {
            return null;
        }
        return this.adviceOtherIUs.toArray(new MetadataFactory.InstallableUnitDescription[this.adviceOtherIUs.size()]);
    }

    public IRequirement[] getMetaRequiredCapabilities() {
        if (this.adviceMetaRequires.isEmpty()) {
            return null;
        }
        return this.adviceMetaRequires.toArray(new IRequirement[this.adviceMetaRequires.size()]);
    }
}

