/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.n4js.cli.compiler.N4jscLanguageClient;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;

@Singleton
public class N4jscTestLanguageClient
extends N4jscLanguageClient {
    @Inject
    XWorkspaceManager workspaceManager;
    Multimap<String, String> errors = HashMultimap.create();
    Multimap<String, String> warnings = HashMultimap.create();
    TreeMap<Path, HashSet<File>> transpiledFiles = new TreeMap();
    Set<URI> deletedFiles = new HashSet<URI>();

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        super.publishDiagnostics(diagnostics);
        List issueList = diagnostics.getDiagnostics();
        if (issueList.isEmpty()) {
            return;
        }
        String uriString = this.issueSerializer.uri(diagnostics.getUri());
        for (Diagnostic diag : issueList) {
            String issueString = this.issueSerializer.diagnostics(diag);
            switch (diag.getSeverity()) {
                case Error: {
                    this.errors.put((Object)uriString, (Object)issueString);
                    break;
                }
                case Warning: {
                    this.warnings.put((Object)uriString, (Object)issueString);
                    break;
                }
            }
        }
    }

    public void afterDelete(URI file) {
        this.deletedFiles.add(file);
    }

    public void afterGenerate(URI source, URI generated) {
        String fileName;
        super.afterGenerate(source, generated);
        if (generated.lastSegment().isBlank()) {
            generated = generated.trimSegments(1);
        }
        if (!(fileName = generated.lastSegment()).endsWith("js") && !fileName.endsWith("jsx")) {
            return;
        }
        Path folder = Paths.get(generated.trimSegments(1).toFileString(), new String[0]);
        URI relGenerated = this.workspaceManager.makeWorkspaceRelative(generated);
        File relFile = new File(relGenerated.toFileString());
        if (!this.transpiledFiles.containsKey(folder)) {
            this.transpiledFiles.put(folder, new HashSet());
        }
        this.transpiledFiles.get(folder).add(relFile);
    }

    public long getDeletionsCount() {
        return this.deletedFiles.size();
    }
}

