/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.n4js.xpect.ui.N4IDEXpectUIPlugin;
import org.eclipse.n4js.xpect.ui.XpectRunConfiguration;
import org.eclipse.n4js.xpect.ui.results.N4IDEXpectRunListener;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectTestClass;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectTestFilesCollector;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.XpectRunner;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class XpectConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected Process process;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        XpectRunConfiguration runConfig = XpectRunConfiguration.fromLaunchConfiguration(configuration);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new DebugEventSetListener());
        try {
            this.execute(launch, runConfig);
        }
        catch (RuntimeException e) {
            N4IDEXpectUIPlugin.logError("Error executing file", e);
        }
    }

    public void execute(ILaunch launch, final XpectRunConfiguration runConfiguration) throws RuntimeException {
        Job job = new Job(launch.getLaunchConfiguration().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                XpectRunner xr;
                try {
                    xr = new XpectRunner(N4IDEXpectTestClass.class);
                }
                catch (InitializationError e) {
                    N4IDEXpectUIPlugin.logError("cannot initialize xpect runner", e);
                    return Status.CANCEL_STATUS;
                }
                String testFileLocation = runConfiguration.getXtFileToRun();
                IXpectURIProvider uriprov = xr.getUriProvider();
                if (uriprov instanceof N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider) {
                    ((N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider)uriprov).addTestFileLocation(testFileLocation);
                }
                Result result = new Result();
                RunNotifier notifier = new RunNotifier();
                RunListener listener = result.createListener();
                N4IDEXpectRunListener n4Listener = new N4IDEXpectRunListener();
                notifier.addFirstListener(listener);
                notifier.addListener((RunListener)n4Listener);
                try {
                    notifier.fireTestRunStarted(xr.getDescription());
                    xr.run(notifier);
                    notifier.fireTestRunFinished(result);
                }
                finally {
                    notifier.removeListener((RunListener)n4Listener);
                    notifier.removeListener(listener);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void terminateProcess() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    class DebugEventSetListener
    implements IDebugEventSetListener {
        DebugEventSetListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent e = debugEventArray[n2];
                switch (e.getKind()) {
                    case 8: {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        XpectConfigurationDelegate.this.terminateProcess();
                        break;
                    }
                }
                ++n2;
            }
        }
    }
}

