/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.fileextensions.FileExtensionTypeHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSCrossReferenceComputer;
import org.eclipse.n4js.resource.N4JSResourceDescription;
import org.eclipse.n4js.resource.N4JSResourceDescriptionDelta;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ts.utils.TypeHelper;
import org.eclipse.n4js.utils.N4JSLanguageHelper;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.DerivedStateAwareResourceDescriptionManager;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.EObjectDescriptionLookUp;

@Singleton
public class N4JSResourceDescriptionManager
extends DerivedStateAwareResourceDescriptionManager
implements N4Scheme {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private TypeHelper typeHelper;
    @Inject
    private N4JSCrossReferenceComputer crossReferenceComputer;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private FileExtensionTypeHelper fileExtensionTypeHelper;
    @Inject
    private N4JSLanguageHelper langHelper;

    protected IResourceDescription createResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        return new N4JSResourceDescription(this.crossReferenceComputer, this.typeHelper, this.qualifiedNameProvider, resource, (N4JSResourceDescriptionStrategy)strategy, this.getCache()){

            protected EObjectDescriptionLookUp getLookUp() {
                if (this.lookup == null) {
                    this.lookup = new EObjectDescriptionLookUp(this.computeExportedObjects());
                }
                return this.lookup;
            }
        };
    }

    public IResourceDescription.Delta createDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
        return new N4JSResourceDescriptionDelta(oldDescription, newDescription);
    }

    public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
        URI candidateURI = candidate.getURI();
        if (this.langHelper.isOpaqueModule(candidateURI)) {
            return false;
        }
        boolean result = this.basicIsAffected(deltas, candidate);
        if (!result) {
            for (IResourceDescription.Delta delta : deltas) {
                URI prefixURI;
                URI uri = delta.getUri();
                if (!"package.json".equalsIgnoreCase(uri.lastSegment()) || candidateURI.replacePrefix(prefixURI = uri.trimSegments(1).appendSegment(""), prefixURI) == null) continue;
                return true;
            }
        }
        return result;
    }

    private boolean basicIsAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate) {
        Collection namesImportedByCandidate = null;
        for (IResourceDescription.Delta delta : deltas) {
            if (!delta.haveEObjectDescriptionsChanged() || !this.fileExtensionTypeHelper.isTypable(delta.getUri().fileExtension())) continue;
            if (namesImportedByCandidate == null) {
                namesImportedByCandidate = this.getImportedNames(candidate);
            }
            if (!this.isAffected(namesImportedByCandidate, delta.getNew()) && !this.isAffected(namesImportedByCandidate, delta.getOld()) || !this.hasDependencyTo(candidate, delta)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDependencyTo(IResourceDescription candidate, IResourceDescription.Delta delta) {
        return this.hasDependencyTo(candidate.getURI(), delta.getUri());
    }

    private boolean hasDependencyTo(URI fromUri, URI toUri) {
        IN4JSProject fromProject = (IN4JSProject)this.n4jsCore.findProject(fromUri).orNull();
        IN4JSProject toProject = (IN4JSProject)this.n4jsCore.findProject(toUri).orNull();
        if (fromProject != null && toProject != null) {
            if (Objects.equals(fromProject, toProject)) {
                return true;
            }
            for (IN4JSProject fromProjectDependency : fromProject.getDependenciesAndImplementedApis()) {
                if (fromProjectDependency.isExternal() != fromProject.isExternal() || !Objects.equals(fromProjectDependency, toProject)) continue;
                return true;
            }
        }
        return false;
    }

    protected void addExportedNames(Set<QualifiedName> names, IResourceDescription resourceDescriptor) {
        if (resourceDescriptor == null) {
            return;
        }
        Iterable iterable = resourceDescriptor.getExportedObjects();
        for (IEObjectDescription ieObjectDescription : iterable) {
            names.add(ieObjectDescription.getName());
        }
    }

    protected boolean isAffected(Collection<QualifiedName> namesImportedByCandidate, IResourceDescription descriptionFromDelta) {
        if (descriptionFromDelta != null) {
            for (IEObjectDescription desc : descriptionFromDelta.getExportedObjects()) {
                if (!namesImportedByCandidate.contains(desc.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

