/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.ui;

import java.text.SimpleDateFormat;
import java.util.Stack;
import org.eclipse.n4js.jsdoc2spec.ui.SpecPage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SpecProcessPage
extends SpecPage {
    private final Stack<Message> msgStack = new Stack();
    private StyledText errorText;
    private Color highlightColor;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss\t ");

    public SpecProcessPage(String name) {
        super(name);
        this.setMessage("Performing specified tasks...");
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        new Label(composite, 0).setText("Messages:");
        this.createErrorGroup(composite);
        Display display = this.getShell().getDisplay();
        this.highlightColor = display.getSystemColor(3);
        this.setControl((Control)composite);
    }

    private void createErrorGroup(Composite parent) {
        Composite errorGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        errorGroup.setLayout((Layout)layout);
        errorGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        errorGroup.setFont(parent.getFont());
        this.errorText = new StyledText(errorGroup, 778);
        this.errorText.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public String displayMessage(String msg) {
        if (msg == null || msg.isEmpty()) {
            return msg;
        }
        return this.displayMessage(msg, null);
    }

    public String displayMessageRed(String msg) {
        if (msg == null || msg.isEmpty()) {
            return msg;
        }
        this.displayMessage(msg, this.highlightColor);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String displayMessage(String msg, Color color) {
        String formattedDate = this.dateFormatter.format(System.currentTimeMillis());
        String timeMsg = String.valueOf(formattedDate) + msg;
        Message m = null;
        Stack<Message> stack = this.msgStack;
        synchronized (stack) {
            Message lastM;
            if (!this.msgStack.isEmpty() && (lastM = (Message)this.msgStack.lastElement()) != null && lastM.color == color) {
                this.msgStack.remove(this.msgStack.size() - 1);
                m = new Message(String.valueOf(lastM.msg) + "\n" + timeMsg, color);
            }
            if (m == null) {
                m = new Message(timeMsg, color);
            }
            this.msgStack.push(m);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SpecProcessPage.this.asyncDisplayMessages();
            }
        });
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncDisplayMessages() {
        Message m = null;
        Stack<Message> stack = this.msgStack;
        synchronized (stack) {
            if (this.msgStack.isEmpty()) {
                return;
            }
            m = this.msgStack.pop();
        }
        int offsetStart = this.errorText.getCharCount();
        this.errorText.append(String.valueOf(m.msg) + "\n");
        int offsetEnd = this.errorText.getCharCount();
        this.errorText.setTopIndex(this.errorText.getLineCount() - 1);
        if (m.color != null) {
            StyleRange range = new StyleRange(offsetStart, offsetEnd - offsetStart, m.color, null);
            this.errorText.setStyleRange(range);
        }
    }

    private class Message {
        final String msg;
        final Color color;

        Message(String msg, Color color) {
            this.msg = msg;
            this.color = color;
        }
    }
}

