/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.hlc.base.ErrorExitCode;
import org.eclipse.n4js.hlc.base.ExitCodeException;
import org.eclipse.n4js.hlc.base.running.RunnableLookupHelper;
import org.eclipse.n4js.hlc.base.testing.LoggingTestListener;
import org.eclipse.n4js.hlc.base.testing.TestReport;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.tester.CliTestTreeXMLTransformer;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.TesterFacade;
import org.eclipse.n4js.tester.TesterFrontEnd;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.extension.ITesterDescriptor;
import org.eclipse.n4js.tester.extension.TesterRegistry;
import org.eclipse.n4js.utils.io.FileDeleter;

public class HeadlessTester {
    private static final String TEST_REPORT_NAME = "test-report.xml";
    @Inject
    private TesterFrontEnd testerFrontEnd;
    @Inject
    private TesterFacade testerFacade;
    @Inject
    private TesterRegistry testerRegistry;
    @Inject
    private TesterEventBus testerEventBus;
    @Inject
    private IHeadlessLogger logger;
    @Inject
    private CliTestTreeXMLTransformer testTreeXmlTransformer;
    @Inject
    RunnableLookupHelper runnerLookup;

    public void runTests(String tester, N4JSProjectName implementationId, URI locationToTest, File testReportRoot) throws ExitCodeException {
        ITesterDescriptor testerDescriptor = this.checkTester(tester);
        this.logger.info("Using tester :" + testerDescriptor.getId());
        TestConfiguration testConfiguration = null;
        try {
            testConfiguration = this.testerFrontEnd.createConfiguration(testerDescriptor.getId(), implementationId, locationToTest);
        }
        catch (IllegalStateException e2) {
            this.logger.error(Throwables.getStackTraceAsString((Throwable)e2));
            throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "Cannot create test configuration.", (Throwable)e2);
        }
        try {
            try {
                TestTree testTree = testConfiguration.getTestTree();
                LoggingTestListener testListener = new LoggingTestListener(this.testerEventBus, this.logger, testTree);
                Process process = this.testerFrontEnd.test(testConfiguration);
                int exit = process.waitFor();
                if (!testListener.finished()) {
                    throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "Test session has not finished.");
                }
                if (testReportRoot != null) {
                    this.createTestReport(testReportRoot, testTree);
                }
                if (!testListener.isOK()) {
                    throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "There were test errors, see console logs and/or test report for details.");
                }
                if (exit != 0) {
                    throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "The spawned tester '" + testerDescriptor.getId() + "' exited with code=" + exit);
                }
            }
            catch (Exception e1) {
                this.logger.error(Throwables.getStackTraceAsString((Throwable)e1));
                throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "The spawned tester exited by throwing an exception", (Throwable)e1);
            }
        }
        finally {
            this.testerFacade.shutdownFramework();
        }
    }

    private ITesterDescriptor checkTester(String tester) throws ExitCodeException {
        List matchingTesterDescs = this.runnerLookup.findRunnableById(tester, this.testerRegistry.getDescriptors());
        if (matchingTesterDescs.isEmpty()) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_NOT_FOUND, "no tester found for id: " + tester);
        }
        if (matchingTesterDescs.size() > 1) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_NOT_FOUND, "several testers match given id \"" + tester + "\":\n\t" + Joiner.on((String)"\n\t").join(matchingTesterDescs));
        }
        return (ITesterDescriptor)matchingTesterDescs.get(0);
    }

    private void createTestReport(File testReportRoot, TestTree testTree) throws ExitCodeException {
        if (!testReportRoot.isDirectory() || !testReportRoot.canWrite()) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "cannot write test report to " + testReportRoot.getAbsolutePath() + ".");
        }
        File report = new File(testReportRoot, TEST_REPORT_NAME);
        try {
            if (report.exists()) {
                FileDeleter.delete((File)report);
            }
            TestReport testReport = new TestReport((StringBuilder)this.testTreeXmlTransformer.apply(testTree));
            testReport.dump(report);
        }
        catch (IOException e) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_TESTER_STOPPED_WITH_ERROR, "Cannot generate test report at: " + report.getAbsolutePath() + ".", (Throwable)e);
        }
    }
}

