/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;

public class MemberList<M extends TMember>
extends ArrayList<M> {
    private static final MemberList<TMember> EMPTY_LIST;
    private static final String SEALED_ERROR = "Member list is sealed,";

    static {
        SealableMemberList<TMember> emptyList = new SealableMemberList<TMember>();
        emptyList.seal();
        EMPTY_LIST = emptyList;
    }

    public static <T extends TMember> MemberList<T> newMemberList() {
        return new MemberList();
    }

    public MemberList() {
    }

    public MemberList(Collection<M> c) {
        super(c);
    }

    public MemberList(int initialCapacity) {
        super(initialCapacity);
    }

    public MemberIterable<TField> fields() {
        return new MemberIterable<TField>(TField.class);
    }

    public MemberIterable<TMethod> methods() {
        return new MemberIterable<TMethod>(TMethod.class);
    }

    public MemberIterable<TGetter> getters() {
        return new MemberIterable<TGetter>(TGetter.class);
    }

    public MemberIterable<TSetter> setters() {
        return new MemberIterable<TSetter>(TSetter.class);
    }

    public MemberIterable<FieldAccessor> accessors() {
        return new MemberIterable<FieldAccessor>(FieldAccessor.class);
    }

    @Override
    public String toString() {
        StringBuilder strb = new StringBuilder("[");
        strb.append(this.stream().map(m -> m != null ? m.getMemberAsString() : "null").collect(Collectors.joining(",")));
        strb.append("]");
        return strb.toString();
    }

    public static <T extends TMember> MemberList<T> emptyList() {
        return EMPTY_LIST;
    }

    public class MemberIterable<T extends TMember>
    implements Iterable<T> {
        private final Class<T> type;

        private MemberIterable(Class<T> type) {
            this.type = type;
        }

        @Override
        public MemberIterator<T> iterator() {
            return new MemberIterator<T>(MemberList.this.iterator(), this.type);
        }

        public boolean isEmpty() {
            return !((MemberIterator)this.iterator()).hasNext();
        }

        public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public String toString() {
            StringBuilder strb = new StringBuilder("[");
            StreamSupport.stream(this.spliterator(), false).map(m -> m.getMemberAsString()).collect(Collectors.joining(","));
            strb.append("]");
            return strb.toString();
        }
    }

    private static class MemberIterator<T extends TMember>
    implements Iterator<T> {
        private final Iterator<? extends TMember> memberIter;
        private final Class<T> type;
        private T next;
        private boolean hasNext;

        private MemberIterator(Iterator<? extends TMember> iterator, Class<T> type) {
            this.memberIter = iterator;
            this.type = type;
            this.hasNext = true;
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T current = this.next;
            this.next = this.findNext();
            return current;
        }

        private T findNext() {
            while (this.memberIter.hasNext()) {
                TMember m = this.memberIter.next();
                if (!this.type.isInstance(m)) continue;
                return (T)m;
            }
            this.hasNext = false;
            return null;
        }
    }

    public static class SealableMemberList<M extends TMember>
    extends MemberList<M> {
        boolean sealed = false;

        public void seal() {
            this.sealed = true;
        }

        @Override
        public M set(int index, M element) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return (M)((TMember)super.set(index, element));
        }

        @Override
        public void add(int index, M element) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            super.add(index, element);
        }

        @Override
        public boolean add(M e) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return super.add(e);
        }

        @Override
        public M remove(int index) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return (M)((TMember)super.remove(index));
        }

        @Override
        public boolean remove(Object o) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return super.remove(o);
        }

        @Override
        public void clear() {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends M> c) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends M> c) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return super.addAll(index, c);
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            super.removeRange(fromIndex, toIndex);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return super.retainAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super M> filter) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            return super.removeIf(filter);
        }

        @Override
        public void replaceAll(UnaryOperator<M> operator) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            super.replaceAll(operator);
        }

        @Override
        public void sort(Comparator<? super M> c) {
            if (this.sealed) {
                throw new IllegalStateException(MemberList.SEALED_ERROR);
            }
            super.sort(c);
        }
    }
}

