/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.n4js.tester.domain.TestStatus;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TestResult
implements Cloneable {
    @JsonProperty
    private TestStatus testStatus;
    private String expected;
    private String actual;
    private String message;
    private List<String> trace;
    private long elapsedTime;

    static TestResult copyOf(TestResult result) {
        if (result == null) {
            return null;
        }
        TestResult copy = new TestResult(result.testStatus);
        copy.expected = result.expected;
        copy.actual = result.actual;
        copy.message = result.message;
        copy.trace = result.trace == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)ImmutableList.copyOf(result.trace));
        copy.elapsedTime = result.elapsedTime;
        return copy;
    }

    private TestResult() {
    }

    public TestResult(TestStatus testStatus) {
        this.testStatus = testStatus;
    }

    public String getExpected() {
        return this.expected;
    }

    public void setExpected(String expected) {
        this.expected = expected;
    }

    public String getActual() {
        return this.actual;
    }

    public void setActual(String actual) {
        this.actual = actual;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getTrace() {
        return this.trace;
    }

    public void setTrace(List<String> trace) {
        this.trace = trace;
    }

    public TestStatus getTestStatus() {
        return this.testStatus;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public TestResult clone() throws CloneNotSupportedException {
        return TestResult.copyOf(this);
    }
}

