/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class CleanUpOptionsCore {
    private final Map<String, String> fOptions;
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public CleanUpOptionsCore(Map<String, String> options) {
        this.fOptions = options;
    }

    public CleanUpOptionsCore() {
        this.fOptions = new Hashtable<String, String>();
    }

    public boolean isEnabled(String key) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        String value = this.fOptions.get(key);
        return TRUE == value || TRUE.equals(value);
    }

    public String getValue(String key) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        String value = this.fOptions.get(key);
        Assert.isLegal((value != null ? 1 : 0) != 0);
        return value;
    }

    public void setOption(String key, String value) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        Assert.isLegal((value != null ? 1 : 0) != 0);
        this.fOptions.put(key, value);
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.fOptions.keySet());
    }
}

