/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.ParallelBuildManager;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ide.server.TopologicalSorter;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class XBuildManager {
    public static final String CYCLIC_PROJECT_DEPENDENCIES = String.valueOf(XBuildManager.class.getName()) + ".cyclicProjectDependencies";
    private XWorkspaceManager workspaceManager;
    @Inject
    private Provider<TopologicalSorter> sorterProvider;
    private final LinkedHashSet<URI> dirtyFiles = new LinkedHashSet();
    private final LinkedHashSet<URI> deletedFiles = new LinkedHashSet();
    private List<IResourceDescription.Delta> unreportedDeltas = new ArrayList<IResourceDescription.Delta>();

    public List<IResourceDescription.Delta> doInitialBuild(List<ProjectDescription> projects, CancelIndicator indicator) {
        List<ProjectDescription> sortedDescriptions = this.sortByDependencies(projects);
        ArrayList<IResourceDescription.Delta> result = new ArrayList<IResourceDescription.Delta>();
        for (ProjectDescription description : sortedDescriptions) {
            String projectName = description.getName();
            XProjectManager projectManager = this.workspaceManager.getProjectManager(projectName);
            XBuildResult partialresult = projectManager.doInitialBuild(indicator);
            result.addAll(partialresult.getAffectedResources());
        }
        return result;
    }

    @Deprecated
    public List<IResourceDescription.Delta> doInitialBuild2(List<ProjectDescription> projects, final CancelIndicator indicator) {
        List<ProjectDescription> sortedDescriptions = this.sortByDependencies(projects);
        List<IResourceDescription.Delta> result = Collections.synchronizedList(new ArrayList());
        class BuildInitialProjectJob
        extends ParallelBuildManager.ParallelJob<String> {
            XProjectManager projectManager;
            List<IResourceDescription.Delta> result;

            BuildInitialProjectJob(XProjectManager projectManager, List<IResourceDescription.Delta> result) {
                this.projectManager = projectManager;
                this.result = result;
            }

            @Override
            public void runJob() {
                XBuildResult partialresult = this.projectManager.doInitialBuild(indicator);
                this.result.addAll(partialresult.getAffectedResources());
            }

            @Override
            public String getID() {
                return this.projectManager.getProjectConfig().getName();
            }

            @Override
            public Collection<String> getDependencyIDs() {
                return this.projectManager.getProjectDescription().getDependencies();
            }
        }
        ArrayList<BuildInitialProjectJob> jobs = new ArrayList<BuildInitialProjectJob>();
        for (ProjectDescription description : sortedDescriptions) {
            String projectName = description.getName();
            XProjectManager projectManager = this.workspaceManager.getProjectManager(projectName);
            BuildInitialProjectJob bpj = new BuildInitialProjectJob(projectManager, result);
            jobs.add(bpj);
        }
        ParallelBuildManager parallelBuildManager = new ParallelBuildManager(jobs);
        parallelBuildManager.run();
        return result;
    }

    public XBuildable doIncrementalBuild(List<URI> dirtyFiles, List<URI> deletedFiles) {
        this.queue(this.dirtyFiles, deletedFiles, dirtyFiles);
        this.queue(this.deletedFiles, dirtyFiles, deletedFiles);
        return this::internalIncrementalBuild;
    }

    protected void queue(Set<URI> files, Collection<URI> toRemove, Collection<URI> toAdd) {
        files.removeAll(toRemove);
        files.addAll(toAdd);
    }

    protected List<IResourceDescription.Delta> internalIncrementalBuild(CancelIndicator cancelIndicator) {
        try {
            Map<ProjectDescription, Set<URI>> project2dirty = this.computeProjectToUriMap(this.dirtyFiles);
            Map<ProjectDescription, Set<URI>> project2deleted = this.computeProjectToUriMap(this.deletedFiles);
            Sets.SetView allDescriptions = Sets.union(project2dirty.keySet(), project2deleted.keySet());
            List<ProjectDescription> sortedDescriptions = this.sortByDependencies((Iterable<ProjectDescription>)allDescriptions);
            for (ProjectDescription descr : sortedDescriptions) {
                XProjectManager projectManager = this.workspaceManager.getProjectManager(descr.getName());
                Set<URI> projectDirty = project2dirty.getOrDefault(descr, Collections.emptySet());
                Set<URI> projectDeleted = project2deleted.getOrDefault(descr, Collections.emptySet());
                XBuildResult partialResult = projectManager.doIncrementalBuild(projectDirty, projectDeleted, this.unreportedDeltas, cancelIndicator);
                this.dirtyFiles.removeAll(projectDirty);
                this.deletedFiles.removeAll(projectDeleted);
                this.mergeWithUnreportedDeltas(partialResult.getAffectedResources());
            }
            List<IResourceDescription.Delta> result = this.unreportedDeltas;
            this.unreportedDeltas = new ArrayList<IResourceDescription.Delta>();
            return result;
        }
        catch (CancellationException ce) {
            throw ce;
        }
        catch (Exception ce) {
            this.dirtyFiles.clear();
            this.deletedFiles.clear();
            throw ce;
        }
    }

    private Map<ProjectDescription, Set<URI>> computeProjectToUriMap(Collection<URI> uris) {
        HashMap<ProjectDescription, Set<URI>> project2uris = new HashMap<ProjectDescription, Set<URI>>();
        for (URI deleted : uris) {
            ProjectDescription projectDescription = this.workspaceManager.getProjectManager(deleted).getProjectDescription();
            if (!project2uris.containsKey(projectDescription)) {
                project2uris.put(projectDescription, new HashSet());
            }
            ((Set)project2uris.get(projectDescription)).add(deleted);
        }
        return project2uris;
    }

    protected void mergeWithUnreportedDeltas(List<IResourceDescription.Delta> newDeltas) {
        if (this.unreportedDeltas.isEmpty()) {
            this.unreportedDeltas.addAll(newDeltas);
        } else {
            Map unreportedByUri = IterableExtensions.toMap(this.unreportedDeltas, IResourceDescription.Delta::getUri);
            for (IResourceDescription.Delta newDelta : newDeltas) {
                IResourceDescription.Delta unreportedDelta = (IResourceDescription.Delta)unreportedByUri.get(newDelta.getUri());
                if (unreportedDelta == null) {
                    this.unreportedDeltas.add(newDelta);
                    continue;
                }
                this.unreportedDeltas.remove(unreportedDelta);
                IResourceDescription _old = unreportedDelta.getOld();
                IResourceDescription _new = newDelta.getNew();
                this.unreportedDeltas.add((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(_old, _new));
            }
        }
    }

    protected List<ProjectDescription> sortByDependencies(Iterable<ProjectDescription> projectDescriptions) {
        return ((TopologicalSorter)this.sorterProvider.get()).sortByDependencies(projectDescriptions, it -> {
            XProjectManager projectManager = this.workspaceManager.getProjectManager(it.getName());
            this.reportDependencyCycle(projectManager);
        });
    }

    protected void reportDependencyCycle(XProjectManager manager) {
        String msg = "Project has cyclic dependencies";
        manager.reportProjectIssue(msg, CYCLIC_PROJECT_DEPENDENCIES, Severity.ERROR);
    }

    public void setWorkspaceManager(XWorkspaceManager workspaceManager) {
        this.workspaceManager = workspaceManager;
    }

    public void persistProjectState(CancelIndicator indicator) {
        for (XProjectManager prjManager : this.workspaceManager.getProjectManagers()) {
            prjManager.persistProjectState();
            if (!indicator.isCanceled()) continue;
            return;
        }
    }

    public static interface XBuildable {
        public static final XBuildable NO_BUILD = cancelIndicator -> Collections.emptyList();

        public List<IResourceDescription.Delta> build(CancelIndicator var1);
    }

    protected static class XProjectBuildData {
        private final List<URI> dirtyFiles;
        private final List<URI> deletedFiles;

        public XProjectBuildData(List<URI> dirtyFiles, List<URI> deletedFiles) {
            this.dirtyFiles = dirtyFiles;
            this.deletedFiles = deletedFiles;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.dirtyFiles == null ? 0 : this.dirtyFiles.hashCode());
            return prime * result + (this.deletedFiles == null ? 0 : this.deletedFiles.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XProjectBuildData other = (XProjectBuildData)obj;
            if (this.dirtyFiles == null ? other.dirtyFiles != null : !this.dirtyFiles.equals(other.dirtyFiles)) {
                return false;
            }
            return !(this.deletedFiles == null ? other.deletedFiles != null : !this.deletedFiles.equals(other.deletedFiles));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("dirtyFiles", this.dirtyFiles);
            b.add("deletedFiles", this.deletedFiles);
            return b.toString();
        }

        public List<URI> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public List<URI> getDeletedFiles() {
            return this.deletedFiles;
        }
    }
}

