/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.IBuildRequestFactory;
import org.eclipse.n4js.ide.xtext.server.IssueAcceptor;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.validation.Issue;

@Singleton
public class DefaultBuildRequestFactory
implements IBuildRequestFactory {
    @Inject
    private IssueAcceptor issueAcceptor;
    @Inject(optional=true)
    private XBuildRequest.AfterValidateListener afterValidateListener = new DefaultAfterValidateListener();
    @Inject(optional=true)
    private XBuildRequest.AfterGenerateListener afterGenerateListener;
    @Inject(optional=true)
    private XBuildRequest.AfterDeleteListener afterDeleteListener;

    @Override
    public XBuildRequest getBuildRequest(Set<URI> changedFiles, Set<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas) {
        XBuildRequest result = new XBuildRequest();
        result.setDirtyFiles(changedFiles);
        result.setDeletedFiles(deletedFiles);
        result.setExternalDeltas(externalDeltas);
        result.setAfterDeleteListener(this.afterDeleteListener);
        result.setAfterValidateListener(this.afterValidateListener);
        result.setAfterGenerateListener(this.afterGenerateListener);
        return result;
    }

    public XBuildRequest.AfterValidateListener getAfterValidateListener() {
        return this.afterValidateListener;
    }

    public void setAfterValidateListener(XBuildRequest.AfterValidateListener afterValidateListener) {
        this.afterValidateListener = afterValidateListener;
    }

    public XBuildRequest.AfterGenerateListener getAfterGenerateListener() {
        return this.afterGenerateListener;
    }

    public void setAfterGenerateListener(XBuildRequest.AfterGenerateListener afterGenerateListener) {
        this.afterGenerateListener = afterGenerateListener;
    }

    public XBuildRequest.AfterDeleteListener getAfterDeleteListener() {
        return this.afterDeleteListener;
    }

    public void setAfterDeleteListener(XBuildRequest.AfterDeleteListener afterDeleteListener) {
        this.afterDeleteListener = afterDeleteListener;
    }

    class DefaultAfterValidateListener
    implements XBuildRequest.AfterValidateListener {
        DefaultAfterValidateListener() {
        }

        @Override
        public void afterValidate(URI source, Collection<Issue> issues) {
            DefaultBuildRequestFactory.this.issueAcceptor.publishDiagnostics(source, issues);
        }
    }
}

