/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.n4idl;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4idl.transpiler.utils.N4IDLTranspilerUtils;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.im.VersionedNamedImportSpecifier_IM;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.xtext.EcoreUtil2;

public class N4IDLVersionedImportsTransformation
extends Transformation {
    public void analyze() {
    }

    public void assertPostConditions() {
        this.assertTrue("There should not be any more implicitly versioned imports in the IM.", EcoreUtil2.getAllContentsOfType((EObject)this.getState().im, VersionedNamedImportSpecifier_IM.class).stream().noneMatch(VersionedNamedImportSpecifier_IM::isVersionedTypeImport));
    }

    public void assertPreConditions() {
    }

    public void transform() {
        EcoreUtil2.getAllContentsOfType((EObject)this.getState().im, ImportDeclaration.class).forEach(this::transformVersionedImportSpecifiers);
    }

    private void transformVersionedImportSpecifiers(ImportDeclaration impDecl) {
        for (ImportSpecifier impSpec : new ArrayList(impDecl.getImportSpecifiers())) {
            VersionedNamedImportSpecifier_IM impSpecCasted;
            if (!(impSpec instanceof VersionedNamedImportSpecifier_IM) || !(impSpecCasted = (VersionedNamedImportSpecifier_IM)impSpec).isVersionedTypeImport()) continue;
            this.transformVersionedImportSpecifier(impSpecCasted);
        }
        if (impDecl.getImportSpecifiers().isEmpty()) {
            this.remove((EObject)impDecl);
        }
    }

    private void transformVersionedImportSpecifier(VersionedNamedImportSpecifier_IM importSpecifier) {
        Collection typeVersionSTEs = this.findSymbolTableEntriesForVersionedTypeImport(importSpecifier);
        typeVersionSTEs.forEach(ste -> {
            ste.setImportSpecifier(null);
            this.addNamedImport((SymbolTableEntryOriginal)ste, null);
            NamedImportSpecifier createdSpecifier = (NamedImportSpecifier)ste.getImportSpecifier();
            createdSpecifier.setImportedElementAsText(N4IDLTranspilerUtils.getVersionedInternalName((IdentifiableElement)ste.getOriginalTarget()));
            this.getState().tracer.copyTrace((EObject)importSpecifier, new EObject[]{createdSpecifier});
        });
        this.remove((EObject)importSpecifier);
    }
}

