/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.RawTypeSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public class ResolvedOperationInHierarchy
extends AbstractResolvedOperation {
    private BottomResolvedOperation bottom;
    private IOverrideCheckResult checkResult;

    protected ResolvedOperationInHierarchy(JvmOperation declaration, BottomResolvedOperation bottom) {
        super(declaration, bottom.getContextType());
        this.bottom = bottom;
    }

    @Override
    public List<JvmTypeParameter> getResolvedTypeParameters() {
        return this.bottom.getResolvedTypeParameters();
    }

    @Override
    public boolean isBottomInContext() {
        return false;
    }

    @Override
    protected BottomResolvedOperation getBottom() {
        return this.bottom;
    }

    @Override
    public IResolvedOperation getAsBottom() {
        JvmOperation operation = (JvmOperation)this.getDeclaration();
        JvmDeclaredType declaringType = operation.getDeclaringType();
        List<LightweightTypeReference> superTypes = this.getContextType().getAllSuperTypes();
        for (LightweightTypeReference superType : superTypes) {
            if (superType.getType() != declaringType) continue;
            return new BottomResolvedOperation(operation, superType, this.getBottom().getOverrideTester());
        }
        throw new IllegalStateException(String.format("Could not find declaring type of method %s in hierarchy of %s", operation.getIdentifier(), this.getContextType().getIdentifier()));
    }

    @Override
    protected TypeParameterSubstitutor<?> getSubstitutor() {
        if (this.isRawTypeInheritance()) {
            return new RawTypeSubstitutor(this.getContextType().getOwner());
        }
        TypeParameterSubstitutor<?> result = super.getSubstitutor();
        List<JvmTypeParameter> typeParameters = this.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            List<JvmTypeParameter> resolvedTypeParameters = this.getResolvedTypeParameters();
            int max = Math.min(typeParameters.size(), resolvedTypeParameters.size());
            ITypeReferenceOwner owner = this.getContextType().getOwner();
            HashMap additionalMapping = Maps.newHashMapWithExpectedSize((int)max);
            for (int i = 0; i < max; ++i) {
                ParameterizedTypeReference localReference = owner.newParameterizedTypeReference((JvmType)resolvedTypeParameters.get(i));
                additionalMapping.put(typeParameters.get(i), new LightweightMergedBoundTypeArgument(localReference, VarianceInfo.INVARIANT));
            }
            result.enhanceMapping(additionalMapping);
        }
        return result;
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getContextTypeParameterMapping() {
        return this.getBottom().getContextTypeParameterMapping();
    }

    @Override
    public IOverrideCheckResult getOverrideCheckResult() {
        return this.checkResult;
    }

    protected void setCheckResult(IOverrideCheckResult checkResult) {
        this.checkResult = checkResult;
    }

    @Override
    public String toString() {
        return String.format("%s overridden by %s", ((JvmOperation)this.getDeclaration()).getIdentifier(), this.getBottom());
    }
}

