/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.impl.tpt.timer;

import org.eclipse.equinox.internal.util.impl.tpt.timer.TimerQueueNode;

class TimerQueue {
    static final int POOL_SIZE = 20;
    QueueElement[] pool = new QueueElement[20];
    int filled = 0;
    QueueElement first;
    QueueElement lastInserted;

    TimerQueue() {
    }

    void add(TimerQueueNode task) {
        QueueElement toAdd = this.getQueueElement();
        toAdd.node = task;
        if (this.first == null) {
            this.first = toAdd;
        } else {
            this.insertElement(toAdd);
        }
    }

    TimerQueueNode getMin() {
        return this.first != null ? this.first.node : null;
    }

    void removeMin() {
        if (this.first != null) {
            if (this.lastInserted == this.first) {
                this.lastInserted = null;
            }
            if (this.filled < 20) {
                QueueElement toFree = this.first;
                this.first = this.first.next;
                this.freeQueueElement(toFree);
            } else {
                this.first = this.first.next;
            }
        }
    }

    void rescheduleMin(long newTime) {
        this.first.node.runOn = newTime;
        if (this.first.next != null) {
            if (this.lastInserted == this.first) {
                this.lastInserted = null;
            }
            QueueElement el = this.first;
            this.first = this.first.next;
            el.next = null;
            this.insertElement(el);
        }
    }

    boolean isEmpty() {
        return this.first == null;
    }

    void clear() {
        while (this.first != null) {
            this.first.node.returnInPool();
            this.first = this.first.next;
        }
        this.lastInserted = null;
    }

    void insertElement(QueueElement newElement) {
        if (this.first.node.runOn >= newElement.node.runOn) {
            newElement.next = this.first;
            this.first = newElement;
        } else if (this.lastInserted != null) {
            if (this.lastInserted.node.runOn == newElement.node.runOn) {
                QueueElement tmp = this.lastInserted.next;
                this.lastInserted.next = newElement;
                newElement.next = tmp;
            } else if (this.lastInserted.node.runOn > newElement.node.runOn) {
                this.doInsertElement(this.first, newElement);
            } else {
                this.doInsertElement(this.lastInserted, newElement);
            }
        } else {
            this.doInsertElement(this.first, newElement);
        }
    }

    void doInsertElement(QueueElement firstEl, QueueElement elToInsert) {
        QueueElement tmp = firstEl;
        QueueElement prev = firstEl;
        while (tmp != null && tmp.node.runOn < elToInsert.node.runOn) {
            prev = tmp;
            tmp = tmp.next;
        }
        if (tmp == null) {
            prev.next = elToInsert;
        } else {
            prev.next = elToInsert;
            elToInsert.next = tmp;
        }
        this.lastInserted = elToInsert;
    }

    void removeTimerNode(TimerQueueNode node) {
        QueueElement tmp = this.first;
        QueueElement prev = null;
        while (tmp != null) {
            if (node.listener == tmp.node.listener && node.event == tmp.node.event) {
                if (prev != null) {
                    if (this.lastInserted == tmp) {
                        this.lastInserted = prev;
                    }
                    prev.next = tmp.next;
                    if (this.filled >= 20) break;
                    this.freeQueueElement(tmp);
                    break;
                }
                if (this.lastInserted == this.first) {
                    this.lastInserted = null;
                }
                if (this.filled < 20) {
                    QueueElement toFree = this.first;
                    this.first = this.first.next;
                    this.freeQueueElement(toFree);
                    break;
                }
                this.first = this.first.next;
                break;
            }
            prev = tmp;
            tmp = tmp.next;
        }
    }

    private QueueElement getQueueElement() {
        return this.filled > 0 ? this.pool[--this.filled] : new QueueElement();
    }

    private void freeQueueElement(QueueElement toFree) {
        if (this.filled < 20) {
            this.pool[this.filled] = toFree;
            ++this.filled;
            toFree.next = null;
            toFree.node = null;
        }
    }

    private class QueueElement {
        QueueElement next;
        TimerQueueNode node;
    }
}

