/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.StandardSystemProperty;

public abstract class OSInfo {
    public static final String OS_NAME = StandardSystemProperty.OS_NAME.value().toLowerCase();
    public static final String OS_ARCH = StandardSystemProperty.OS_ARCH.value().toLowerCase();

    private OSInfo() {
    }

    public static boolean isWindows() {
        return OS_NAME.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS_NAME.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS_NAME.indexOf("nix") >= 0 || OS_NAME.indexOf("nux") >= 0 || OS_NAME.indexOf("aix") > 0;
    }

    public static boolean is64bit() {
        boolean is64bit = false;
        is64bit = OSInfo.isWindows() ? System.getenv("ProgramFiles(x86)") != null : OS_ARCH.contains("64");
        return is64bit;
    }

    public static String getArchDescriptor() {
        return OSInfo.is64bit() ? "64" : "32";
    }
}

