/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.n4js.smith.DataCollector;
import org.eclipse.n4js.smith.DataCollectors;
import org.eclipse.n4js.smith.DataPoint;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.TimedMeasurement;

class TimedDataCollector
extends DataCollector {
    public static final boolean AVOID_EXCESSIVE_DATA_COLLECTION = true;
    private final String id;
    private final DataCollector parent;
    private final Map<String, DataCollector> children = new LinkedHashMap<String, DataCollector>();
    private static final TimedMeasurement NULL_MEASURMENT = new TimedMeasurement("NOOP", TimedDataCollector::noop);
    private boolean paused = true;
    private Measurement activeMeasurement = null;
    private final List<DataPoint> data = new LinkedList<DataPoint>();

    public TimedDataCollector(String id) {
        this(id, null);
    }

    public TimedDataCollector(String id, DataCollector parent) {
        this.id = id;
        this.parent = parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean hasActiveMeasurement() {
        return this.activeMeasurement != null;
    }

    @Override
    public synchronized Measurement getMeasurement(String name) {
        if (name == null || name.isEmpty()) {
            throw new RuntimeException(String.valueOf(TimedMeasurement.class.getName()) + " needs non empty name.");
        }
        if (this.paused) {
            return NULL_MEASURMENT;
        }
        if (this.activeMeasurement != null) {
            DataCollectors.INSTANCE.warn("reentrant invocation of #getMeasurement() in data collector " + this.id);
            return NULL_MEASURMENT;
        }
        this.activeMeasurement = new TimedMeasurement(name, this::consume);
        return this.activeMeasurement;
    }

    private synchronized void consume(TimedMeasurement measurement) {
        if (measurement != this.activeMeasurement) {
            DataCollectors.INSTANCE.warn("invocation of #consume() without matching prior call to #getMeasurement() in data collector " + this.id + "#" + measurement.name);
            return;
        }
        this.activeMeasurement = null;
        String name = measurement.name;
        long elapsed = measurement.elapsed(TimeUnit.NANOSECONDS);
        for (DataPoint dp : this.data) {
            elapsed += dp.nanos.longValue();
        }
        this.data.clear();
        this.data.add(new DataPoint(name, elapsed));
    }

    @Override
    public List<DataPoint> getData() {
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public DataCollector getParent() {
        return this.parent;
    }

    @Override
    public Collection<DataCollector> getChildren() {
        return this.children.values();
    }

    @Override
    public DataCollector getChild(String key) {
        return this.children.get(key);
    }

    @Override
    public void addChild(String key, DataCollector child) {
        if (this.children.containsKey(key)) {
            throw new RuntimeException("Already contains key " + key + " with child " + this.children.get(key));
        }
        if (this.children.containsValue(child)) {
            String keys = this.children.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), child)).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]"));
            throw new RuntimeException("Already contains child " + child + " with keys " + keys);
        }
        this.children.put(key, child);
    }

    @Override
    public Collection<String> childrenKeys() {
        return this.children.keySet();
    }

    @Override
    public void setPaused(boolean paused) {
        this.activeMeasurement = null;
        this.paused = paused;
        this.children.values().forEach(child -> child.setPaused(paused));
    }

    @Override
    public void purgeData() {
        this.activeMeasurement = null;
        this.data.clear();
        this.children.values().forEach(c -> c.purgeData());
    }

    private static void noop(Measurement measurement) {
    }
}

