/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.resource.PostProcessingAwareResource;
import org.eclipse.n4js.resource.UserdataMapper;
import org.eclipse.n4js.scoping.diagnosing.N4JSScopingDiagnostician;
import org.eclipse.n4js.scoping.utils.CanLoadFromDescriptionHelper;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.util.TypeModelUtils;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageHelper;
import org.eclipse.n4js.utils.emf.ProxyResolvingResource;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.resource.XtextSyntaxDiagnosticWithRange;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.Triple;

public class N4JSResource
extends PostProcessingAwareResource
implements ProxyResolvingResource {
    private static final Logger LOGGER = Logger.getLogger(N4JSResource.class);
    private static final Logger logger = Logger.getLogger(N4JSResource.class);
    public static final String AST_PROXY_FRAGMENT = ":astProxy";
    private ASTMetaInfoCache astMetaInfoCache;
    private boolean aboutToBeUnloaded;
    private boolean removingAdapters;
    @Inject
    private N4JSScopingDiagnostician scopingDiagnostician;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private CanLoadFromDescriptionHelper canLoadFromDescriptionHelper;
    @Inject
    private IDerivedStateComputer myDerivedStateComputer;
    @Inject
    private N4JSLanguageHelper langHelper;

    @Inject
    public N4JSResource() {
    }

    public void setURI(URI uri) {
        if (uri != null && uri.isFile() && !uri.isRelative() && !uri.hasAuthority()) {
            throw new IllegalArgumentException("File URI without authority: " + uri);
        }
        super.setURI(uri);
    }

    public ASTMetaInfoCache getASTMetaInfoCacheVerifyContext() {
        if (this.astMetaInfoCache == null) {
            if (!this.isFullyProcessed() && !this.isPostProcessing()) {
                throw new IllegalStateException("AST meta-info cache only available in state 'Fully Processed' and during post-processing");
            }
            throw new NullPointerException("AST meta-info cache missing");
        }
        return this.astMetaInfoCache;
    }

    public ASTMetaInfoCache getASTMetaInfoCache() {
        return this.astMetaInfoCache;
    }

    public void setASTMetaInfoCache(ASTMetaInfoCache cache) {
        this.astMetaInfoCache = cache;
    }

    public boolean isOpaque() {
        return this.langHelper.isOpaqueModule(this.uri);
    }

    public boolean isReconciled() {
        TModule module = this.getModule();
        return module != null && module.isReconciled();
    }

    public synchronized EList<EObject> getContents() {
        if (!this.removingAdapters) {
            return super.getContents();
        }
        return this.doGetContents();
    }

    protected EList<EObject> doGetContents() {
        if (this.contents == null) {
            this.contents = new ModuleAwareContentsList();
        }
        return this.contents;
    }

    public EList<Adapter> eAdapters() {
        if (this.eAdapters == null) {
            this.eAdapters = new BasicNotifierImpl.EAdapterList<Adapter>((Notifier)this){

                protected void didRemove(int index, Adapter oldObject) {
                    boolean wasRemoving = N4JSResource.this.removingAdapters;
                    try {
                        N4JSResource.this.removingAdapters = true;
                        super.didRemove(index, (Object)oldObject);
                    }
                    finally {
                        N4JSResource.this.removingAdapters = wasRemoving;
                    }
                }
            };
        }
        return this.eAdapters;
    }

    public boolean loadFromDescription(IResourceDescription description) {
        if (this.isLoaded) {
            throw new IllegalStateException("Resource was already loaded");
        }
        TModule deserializedModule = null;
        Iterable modules = description.getExportedObjectsByType(TypesPackage.Literals.TMODULE);
        for (IEObjectDescription module : modules) {
            deserializedModule = UserdataMapper.getDeserializedModuleFromDescription(module, this.getURI());
            if (deserializedModule != null) break;
        }
        if (deserializedModule != null) {
            boolean wasDeliver = this.eDeliver();
            try {
                this.eSetDeliver(false);
                ModuleAwareContentsList theContents = (ModuleAwareContentsList)this.getContents();
                if (!theContents.isEmpty()) {
                    throw new IllegalStateException("There is already something in the contents list: " + (Object)((Object)theContents));
                }
                InternalEObject astProxy = (InternalEObject)N4JSFactory.eINSTANCE.createScript();
                astProxy.eSetProxyURI(URI.createURI((String)"#:astProxy"));
                theContents.sneakyAdd((EObject)astProxy);
                theContents.sneakyAdd((EObject)deserializedModule);
                this.fullyInitialized = true;
                this.fullyPostProcessed = true;
            }
            finally {
                this.eSetDeliver(wasDeliver);
            }
            return true;
        }
        return false;
    }

    public boolean isLoadedFromDescription() {
        Script script = this.getScript();
        TModule module = this.getModule();
        return script != null && module != null && this.isASTProxy((EObject)script) && !module.eIsProxy();
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Attempt to save a resource that was not loaded: " + this.getURI());
        }
        super.doSave(outputStream, options);
    }

    private EObject demandLoadResource(EObject object) {
        TModule oldModule = null;
        EObject oldScript = null;
        ModuleAwareContentsList myContents = (ModuleAwareContentsList)this.contents;
        try {
            oldModule = this.discardStateFromDescription(false);
            if (!myContents.isEmpty()) {
                oldScript = (EObject)myContents.basicGet(0);
                myContents.sneakyClear();
            }
            this.eSetDeliver(false);
            if (this.isLoaded) {
                this.isLoaded = false;
            }
            this.superLoad(null);
            this.eSetDeliver(true);
            EObject result = this.getParseResult().getRootASTElement();
            if (myContents.isEmpty()) {
                myContents.sneakyAdd(0, result);
                if (oldModule != null) {
                    myContents.sneakyAdd((EObject)oldModule);
                }
                this.forceInstallDerivedState(false);
            } else {
                if (myContents.size() == 1 && oldModule != null) {
                    myContents.sneakyAdd((EObject)oldModule);
                }
                this.installDerivedState(false);
            }
            if (oldScript != null) {
                this.notifyProxyResolved(0, oldScript);
            }
            this.fullyPostProcessed = false;
            return result;
        }
        catch (IOException | IllegalStateException ioe) {
            IStatus status;
            Throwable cause;
            if (myContents.isEmpty()) {
                myContents.sneakyAdd(oldScript);
                myContents.sneakyAdd((EObject)oldModule);
            }
            if ((cause = ioe.getCause()) instanceof CoreException && 368 == (status = ((CoreException)cause).getStatus()).getCode()) {
                return object;
            }
            logger.error((Object)("Error in demandLoadResource for " + this.getURI()), (Throwable)ioe);
            return object;
        }
    }

    private void superLoad(Map<?, ?> options) throws IOException {
        super.load(options);
    }

    private void forceInstallDerivedState(boolean preIndexingPhase) {
        if (!this.isLoaded) {
            throw new IllegalStateException("The resource must be loaded, before installDerivedState can be called.");
        }
        this.fullyInitialized = false;
        this.isInitializing = false;
        this.installDerivedState(preIndexingPhase);
    }

    protected void notifyProxyResolved(int idx, EObject oldProxy) {
        if (this.eNotificationRequired() && idx < this.contents.size()) {
            EObject newObject = (EObject)this.contents.basicGet(idx);
            NotificationImpl notification = new NotificationImpl(9, oldProxy, newObject){

                public Object getNotifier() {
                    return N4JSResource.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 2;
                }
            };
            this.eNotify((Notification)notification);
            for (Adapter adapter : this.eAdapters()) {
                if (!(adapter instanceof EContentAdapter) || newObject.eAdapters().contains((Object)adapter)) continue;
                newObject.eAdapters().add((Object)adapter);
            }
        }
    }

    public void sneakyAddToContent(EObject object) {
        ((ModuleAwareContentsList)this.contents).sneakyAdd(object);
    }

    protected void updateInternalState(IParseResult newParseResult) {
        this.setParseResult(newParseResult);
        EObject newRootAstElement = newParseResult.getRootASTElement();
        if (newRootAstElement != null && !this.getContents().contains((Object)newRootAstElement)) {
            this.sneakyAddToContent(newRootAstElement);
        }
        this.reattachModificationTracker(newRootAstElement);
        this.clearErrorsAndWarnings();
        this.addSyntaxErrors();
        this.doLinking();
        IResourceScopeCache cache = this.getCache();
        if (cache instanceof OnChangeEvictingCache) {
            ((OnChangeEvictingCache)cache).getOrCreate((Resource)this);
        }
    }

    protected void doLinking() {
        if (this.isOpaque()) {
            return;
        }
        super.doLinking();
    }

    protected void clearErrorsAndWarnings() {
        if (this.warnings != null) {
            this.warnings.clear();
        }
        if (this.errors != null) {
            this.errors.clear();
        }
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        if (this.contents != null && !this.contents.isEmpty()) {
            this.discardStateFromDescription(true);
        }
        if (this.isOpaque()) {
            JSParseResult result = new JSParseResult(inputStream);
            this.updateInternalState(this.getParseResult(), result);
        } else {
            super.doLoad(inputStream, options);
        }
    }

    public void update(int offset, int replacedTextLength, String newText) {
        if (this.isOpaque()) {
            String oldText = this.getParseResult().getRootNode().getText();
            String newCompleteString = String.valueOf(oldText.substring(0, offset)) + newText + oldText.substring(offset + replacedTextLength);
            JSParseResult jsParseResult = (JSParseResult)this.getParseResult();
            jsParseResult.setText(newCompleteString);
        } else {
            super.update(offset, replacedTextLength, newText);
        }
    }

    @Override
    protected void doUnload() {
        this.aboutToBeUnloaded = false;
        super.doUnload();
        this.clearLazyProxyInformation();
    }

    public void unloadAST() {
        if (this.getScript() == null || this.getScript().eIsProxy()) {
            return;
        }
        this.discardAST();
        this.setParseResult(null);
        this.getErrors().clear();
        this.getWarnings().clear();
        this.fullyPostProcessed = this.fullyInitialized;
        this.aboutToBeUnloaded = false;
        this.isInitializing = false;
        this.isLoading = false;
        this.isLoaded = false;
        this.isPostProcessing = false;
        this.isUpdating = false;
        this.clearLazyProxyInformation();
        TModule module = this.getModule();
        if (module != null && module.isReconciled()) {
            EcoreUtilN4.doWithDeliver((boolean)false, () -> module.setReconciled(false), (Object[])new Object[]{module});
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        if (this.contents != null && !this.contents.isEmpty()) {
            Notification notification = this.setLoaded(true);
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            this.fullyInitialized = this.contents.size() > 1;
        } else {
            this.superLoad(options);
        }
    }

    public void forceSetLoaded() {
        this.isLoaded = true;
        this.aboutToBeUnloaded = true;
    }

    private void discardAST() {
        Script script = this.getScript();
        if (script != null && !script.eIsProxy()) {
            InternalEObject scriptProxy = (InternalEObject)EcoreUtil.create((EClass)script.eClass());
            scriptProxy.eSetProxyURI(EcoreUtil.getURI((EObject)script));
            TModule module = null;
            ModuleAwareContentsList theContents = (ModuleAwareContentsList)this.contents;
            if (this.isFullyInitialized() && (module = this.getModule()) != null && !module.eIsProxy()) {
                this.proxifyASTReferences((EObject)module);
                module.setAstElement((EObject)scriptProxy);
            }
            this.unloadElements(theContents.subList(0, 1));
            theContents.sneakyClear();
            if (module != null) {
                theContents.sneakyAdd((EObject)scriptProxy);
                theContents.sneakyAdd((EObject)module);
            }
            this.setASTMetaInfoCache(null);
            this.getCache().clear((Resource)this);
        }
    }

    private void proxifyASTReferences(EObject object) {
        SyntaxRelatedTElement element;
        EObject astElement;
        if (object instanceof SyntaxRelatedTElement && (astElement = (element = (SyntaxRelatedTElement)object).getAstElement()) != null && !astElement.eIsProxy()) {
            InternalEObject proxy = (InternalEObject)EcoreUtil.create((EClass)astElement.eClass());
            proxy.eSetProxyURI(EcoreUtil.getURI((EObject)astElement));
            element.setAstElement((EObject)proxy);
        }
        for (EObject child : object.eContents()) {
            this.proxifyASTReferences(child);
        }
    }

    protected TModule discardStateFromDescription(boolean unload) {
        ModuleAwareContentsList theContents = (ModuleAwareContentsList)this.contents;
        if (theContents != null && !theContents.isEmpty()) {
            if (theContents.size() == 2) {
                EObject eObject = (EObject)theContents.get(1);
                if (eObject instanceof TModule) {
                    TModule module = (TModule)eObject;
                    if (unload) {
                        this.getUnloader().unloadRoot((EObject)module);
                    }
                    return module;
                }
                this.getUnloader().unloadRoot(eObject);
                return null;
            }
            if (theContents.size() > 2) {
                throw new IllegalStateException("Unexpected size: " + (Object)((Object)theContents));
            }
        }
        return null;
    }

    public void installDerivedState(boolean preIndexingPhase) {
        block15: {
            if (!this.isLoaded) {
                throw new IllegalStateException("The resource must be loaded, before installDerivedState can be called.");
            }
            if (!(this.fullyInitialized || this.isInitializing || this.isLoadedFromStorage())) {
                boolean newFullyInitialized = true;
                try {
                    try {
                        this.isInitializing = true;
                        if (this.myDerivedStateComputer == null) break block15;
                        EList<EObject> roots = this.doGetContents();
                        if (roots.size() > 2) {
                            throw new IllegalStateException("The resource should not have more than two root elements, but: " + roots);
                        }
                        try {
                            this.myDerivedStateComputer.installDerivedState((DerivedStateAwareResource)this, preIndexingPhase);
                        }
                        catch (Throwable e) {
                            if (this.operationCanceledManager.isOperationCanceledException(e)) {
                                this.doDiscardDerivedState();
                                newFullyInitialized = false;
                                this.operationCanceledManager.propagateAsErrorIfCancelException(e);
                            }
                            Throwables.throwIfUnchecked((Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                    catch (RuntimeException e) {
                        this.getErrors().add((Object)new ExceptionDiagnostic((Exception)e));
                        throw e;
                    }
                }
                finally {
                    this.fullyInitialized = newFullyInitialized;
                    this.isInitializing = false;
                    try {
                        this.setASTMetaInfoCache(null);
                        this.getCache().clear((Resource)this);
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void unloadElements(List<EObject> toBeUnloaded) {
        for (EObject object : toBeUnloaded) {
            this.getUnloader().unloadRoot(object);
        }
    }

    public String getURIFragment(EObject eObject) {
        if (this.eDeliver()) {
            if (this.contents != null && !this.contents.isEmpty() && this.isASTProxy((EObject)this.contents.basicGet(0))) {
                return this.defaultGetURIFragment(eObject);
            }
            return super.getURIFragment(eObject);
        }
        return this.defaultGetURIFragment(eObject);
    }

    public EObject doResolveProxy(InternalEObject proxy, EObject objectContext) {
        this.performPostProcessing();
        URI targetUri = proxy.eProxyURI();
        boolean isLazyLinkingProxy = this.getEncoder().isCrossLinkFragment((Resource)this, targetUri.fragment());
        if (!isLazyLinkingProxy) {
            ResourceSet resSet = this.getResourceSet();
            URI targetResourceUri = targetUri.trimFragment();
            String targetFileExt = targetResourceUri.fileExtension();
            if ("n4js".equals(targetFileExt) || "n4jsd".equals(targetFileExt) || "n4jsx".equals(targetFileExt)) {
                Resource targetResource2;
                EObject targetObject;
                boolean canLoadFromDescription;
                boolean bl = canLoadFromDescription = !targetUri.fragment().startsWith("/0") && this.canLoadFromDescriptionHelper.canLoadFromDescription(targetResourceUri, this.getResourceSet());
                if (canLoadFromDescription) {
                    IResourceDescriptions index;
                    IResourceDescription resDesc;
                    String targetFragment = targetUri.fragment();
                    Resource targetResource = resSet.getResource(targetResourceUri, false);
                    if (targetResource == null && targetFragment != null && (targetFragment.equals("/1") || targetFragment.startsWith("/1/")) && (resDesc = (index = this.n4jsCore.getXtextIndex(resSet)).getResourceDescription(targetResourceUri)) != null) {
                        this.n4jsCore.loadModuleFromIndex(resSet, resDesc, false);
                    }
                }
                try {
                    targetObject = resSet.getEObject(targetUri, true);
                }
                catch (Exception exc) {
                    if (exc.getCause() instanceof FileNotFoundException) {
                        LOGGER.warn((Object)"File not found during proxy resolution", (Throwable)exc);
                        return proxy;
                    }
                    if (exc.getCause() instanceof ResourceException) {
                        LOGGER.warn((Object)"Resource not found during proxy resolution", (Throwable)exc);
                        return proxy;
                    }
                    throw exc;
                }
                if (targetObject != null && (this.isPostProcessing() || this.isFullyProcessed()) && (targetResource2 = targetObject.eResource()) instanceof N4JSResource) {
                    ((N4JSResource)targetResource2).performPostProcessing();
                }
                return targetObject != null ? targetObject : proxy;
            }
        }
        return EcoreUtil.resolve((EObject)proxy, (Resource)this);
    }

    public synchronized EObject getEObject(String uriFragment) {
        EObject result = super.getEObject(uriFragment);
        if (result == null && this.isLoaded() && !this.isFullyProcessed() && !this.isLoadedFromDescription() && TypeModelUtils.isURIFragmentToPostProcessingCache((String)uriFragment)) {
            this.performPostProcessing();
            result = super.getEObject(uriFragment);
        }
        return result;
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        if (this.contents != null && !this.contents.isEmpty() && this.isASTProxy((EObject)this.contents.basicGet(0))) {
            int position = 0;
            if (uriFragmentRootSegment.length() > 0) {
                try {
                    position = Integer.parseInt(uriFragmentRootSegment);
                }
                catch (NumberFormatException exception) {
                    throw new WrappedException((Exception)exception);
                }
            }
            if (position < this.contents.size() && position >= 1) {
                return (EObject)this.contents.get(position);
            }
            if (position >= 1 && this.isLoaded && this.isASTProxy((EObject)this.contents.basicGet(0)) && this.contents.size() == 1) {
                this.contents.get(0);
            }
        }
        return super.getEObjectForURIFragmentRootSegment(uriFragmentRootSegment);
    }

    private String defaultGetURIFragment(EObject eObject) {
        InternalEObject internalEObject = (InternalEObject)eObject;
        if (internalEObject.eDirectResource() == this || this.unloadingContents != null && this.unloadingContents.contains(internalEObject)) {
            return "/" + this.getURIFragmentRootSegment(eObject);
        }
        SegmentSequence.Builder builder = SegmentSequence.newBuilder((String)"/");
        boolean isContained = false;
        InternalEObject container = internalEObject.eInternalContainer();
        while (container != null) {
            builder.append(container.eURIFragmentSegment(internalEObject.eContainingFeature(), (EObject)internalEObject));
            internalEObject = container;
            if (container.eDirectResource() == this || this.unloadingContents != null && this.unloadingContents.contains(container)) {
                isContained = true;
                break;
            }
            container = internalEObject.eInternalContainer();
        }
        if (!isContained) {
            return "/-1";
        }
        builder.append(this.getURIFragmentRootSegment((EObject)internalEObject));
        builder.append("");
        builder.reverse();
        return builder.toSegmentSequence().toString();
    }

    protected boolean isASTProxy(EObject object) {
        if (object.eIsProxy()) {
            String fragment = EcoreUtil.getURI((EObject)object).fragment();
            return fragment.equals(AST_PROXY_FRAGMENT);
        }
        return false;
    }

    public Triple<EObject, EReference, INode> getLazyProxyInformation(int idx) {
        this.contents.get(0);
        return super.getLazyProxyInformation(idx);
    }

    protected void addSyntaxErrors() {
        if (this.isValidationDisabled()) {
            return;
        }
        BasicEList errorList = (BasicEList)this.getErrors();
        BasicEList warningList = (BasicEList)this.getWarnings();
        for (INode error : this.getParseResult().getSyntaxErrors()) {
            XtextSyntaxDiagnostic diagnostic = this.createSyntaxDiagnostic(error);
            String code = diagnostic.getCode();
            if ("N4JSStringValueConverter.bad.escapement.warn".equals(code) || "RegExLiteralConverter.bogus.regex".equals(code) || "N4JSStringValueConverter.bad.escapement.warn".equals(code)) {
                warningList.addUnique((Object)diagnostic);
                continue;
            }
            if ("InternalSemicolonInjectingParser.ASI".equals(code)) continue;
            errorList.addUnique((Object)diagnostic);
        }
    }

    private XtextSyntaxDiagnostic createSyntaxDiagnostic(INode error) {
        String[] issueData;
        SyntaxErrorMessage syntaxErrorMessage = error.getSyntaxErrorMessage();
        if ("org.eclipse.xtext.diagnostics.Diagnostic.Syntax.Range".equals(syntaxErrorMessage.getIssueCode()) && (issueData = syntaxErrorMessage.getIssueData()).length == 1) {
            String data = issueData[0];
            int colon = data.indexOf(58);
            return new XtextSyntaxDiagnosticWithRange(error, Integer.valueOf(data.substring(0, colon)), Integer.valueOf(data.substring(colon + 1)), null){

                public int getLine() {
                    return this.getNode().getTotalStartLine();
                }
            };
        }
        return new XtextSyntaxDiagnostic(error);
    }

    protected EObject handleCyclicResolution(Triple<EObject, EReference, INode> triple) throws AssertionError {
        if (N4JSPackage.Literals.IDENTIFIER_REF__ID == triple.getSecond() || N4JSPackage.Literals.PARAMETERIZED_PROPERTY_ACCESS_EXPRESSION__PROPERTY == triple.getSecond()) {
            return null;
        }
        return super.handleCyclicResolution(triple);
    }

    public static final void postProcessContainingN4JSResourceOf(EObject object) {
        if (object != null) {
            N4JSResource.postProcess(object.eResource());
        }
    }

    public static final void postProcess(Resource resource) {
        if (resource instanceof N4JSResource && resource.isLoaded()) {
            ((N4JSResource)resource).performPostProcessing();
        }
    }

    @Override
    public void performPostProcessing(CancelIndicator cancelIndicator) {
        boolean isPreLinkingPhase;
        TModule module = this.getModule();
        boolean bl = isPreLinkingPhase = module != null && module.isPreLinkingPhase();
        if (!isPreLinkingPhase) {
            super.performPostProcessing(cancelIndicator);
        }
    }

    @Override
    public void resolveLazyCrossReferences(CancelIndicator mon) {
        Script script = this.getScriptResolved();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Measurement m = N4JSDataCollectors.dcN4JSResource.getMeasurement(this.getURI().toString());){
            super.resolveLazyCrossReferences(mon);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (script != null) {
            EcoreUtilN4.doWithDeliver((boolean)false, () -> script.setFlaggedUsageMarkingFinished(true), (Object[])new Object[]{script});
        }
    }

    public Script getScript() {
        return this.contents != null && !this.contents.isEmpty() ? (Script)this.contents.basicGet(0) : null;
    }

    public Script getScriptResolved() {
        return this.getContents().size() >= 1 ? (Script)this.getContents().get(0) : null;
    }

    public TModule getModule() {
        return this.contents != null && this.contents.size() >= 2 ? (TModule)this.contents.basicGet(1) : null;
    }

    public static TModule getModule(Resource contextResource) {
        if (contextResource == null) {
            return null;
        }
        EList resourceContents = contextResource.getContents();
        int i = resourceContents.size() - 1;
        while (i >= 0) {
            EObject candidate = (EObject)resourceContents.get(i);
            if (candidate instanceof TModule) {
                return (TModule)candidate;
            }
            if (candidate instanceof Script) {
                return ((Script)candidate).getModule();
            }
            --i;
        }
        return null;
    }

    public void clearResolving() {
        this.resolving.clear();
    }

    protected void createAndAddDiagnostic(Triple<EObject, EReference, INode> triple) {
        DiagnosticMessage scopingDiagnostic = this.scopingDiagnostician.getMessageFor((EObject)triple.getFirst(), (EReference)triple.getSecond(), (INode)triple.getThird());
        if (scopingDiagnostic != null) {
            Resource.Diagnostic diagnostic;
            List list = this.getDiagnosticList(scopingDiagnostic);
            if (!list.contains(diagnostic = this.createDiagnostic(triple, scopingDiagnostic))) {
                list.add(diagnostic);
            }
        } else {
            super.createAndAddDiagnostic(triple);
        }
    }

    public void addTemporaryType(Type type) {
        TModule module = this.getModule();
        if (module == null || module.eIsProxy()) {
            throw new IllegalStateException("trying to add temporary type but module is null or a proxy");
        }
        if (!module.getTemporaryTypes().contains((Object)type)) {
            EcoreUtilN4.doWithDeliver((boolean)false, () -> module.getTemporaryTypes().add((Object)type), (Object[])new Object[]{module});
        }
    }

    public void clearTemporaryTypes() {
        TModule module = this.getModule();
        if (module == null || module.eIsProxy()) {
            throw new IllegalStateException("trying to clear temporary types but module is null or a proxy");
        }
        if (!module.getTemporaryTypes().isEmpty()) {
            EcoreUtilN4.doWithDeliver((boolean)false, () -> module.getTemporaryTypes().clear(), (Object[])new Object[]{module});
        }
    }

    static class JSParseResult
    implements IParseResult {
        final EObject scriptNode = N4JSFactory.eINSTANCE.createScript();
        final RootNode rootNode = new RootNode();

        JSParseResult(InputStream inputStream) {
            this(JSParseResult.getCompleteString(inputStream));
        }

        JSParseResult(String text) {
            this.setText(text);
            this.scriptNode.eAdapters().add((Object)this.rootNode);
        }

        private static String getCompleteString(InputStream inputStream) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), Charsets.UTF_8);){
                    return CharStreams.toString((Readable)inputStreamReader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error when reading contents of JS file", (Throwable)e);
                return "";
            }
        }

        public EObject getRootASTElement() {
            return this.scriptNode;
        }

        public ICompositeNode getRootNode() {
            return this.rootNode;
        }

        public Iterable<INode> getSyntaxErrors() {
            return Collections.emptyList();
        }

        public boolean hasSyntaxErrors() {
            return false;
        }

        void setText(String text) {
            try {
                String methodName = "basicSetCompleteContent";
                Method basicSetCompleteContent = RootNode.class.getDeclaredMethod(methodName, String.class);
                basicSetCompleteContent.setAccessible(true);
                basicSetCompleteContent.invoke((Object)this.rootNode, text);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error when setting contents of JS file", (Throwable)e);
            }
        }
    }

    private final class ModuleAwareContentsList
    extends ResourceImpl.ContentsEList<EObject> {
        private static final long serialVersionUID = 1L;

        public ModuleAwareContentsList() {
            super((ResourceImpl)N4JSResource.this);
        }

        protected EObject resolve(int index, EObject object) {
            if (index == 0 && !N4JSResource.this.aboutToBeUnloaded && N4JSResource.this.isASTProxy(object)) {
                EObject result = N4JSResource.this.demandLoadResource(object);
                return result;
            }
            return (EObject)super.resolve(index, (Object)object);
        }

        protected void didAdd(int index, EObject object) {
            if (index == 0 && N4JSResource.this.isASTProxy(object)) {
                return;
            }
            super.didAdd(index, (Object)object);
        }

        protected void sneakyAdd(EObject object) {
            this.sneakyGrow(this.size + 1);
            this.assign(this.size, (EObject)this.validate(this.size, object));
            ++this.size;
            this.inverseAdd(object, null);
        }

        private void sneakyGrow(int minimumCapacity) {
            int oldCapacity;
            int n = oldCapacity = this.data == null ? 0 : this.data.length;
            if (minimumCapacity > oldCapacity) {
                Object[] oldData = this.data;
                int newCapacity = oldCapacity + oldCapacity / 2 + 4;
                if (newCapacity < minimumCapacity) {
                    newCapacity = minimumCapacity;
                }
                this.data = this.newData(newCapacity);
                if (oldData != null) {
                    System.arraycopy(oldData, 0, this.data, 0, this.size);
                }
            }
        }

        protected void sneakyAdd(int index, EObject object) {
            this.sneakyGrow(this.size + 1);
            EObject validatedObject = (EObject)this.validate(index, object);
            if (index != this.size) {
                System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
            }
            this.assign(index, validatedObject);
            ++this.size;
            this.inverseAdd(object, null);
        }

        protected void sneakyClear() {
            BasicEList.UnmodifiableEList collection = new BasicEList.UnmodifiableEList(this.size, this.data);
            this.sneakyDoClear();
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                this.inverseRemove((EObject)i.next(), null);
            }
        }

        private void sneakyDoClear() {
            this.data = null;
            this.size = 0;
        }
    }
}

