/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.builtin;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.scoping.builtin.GlobalObjectScopeAccess;
import org.eclipse.n4js.ts.scoping.builtin.EnumerableScope;
import org.eclipse.n4js.ts.scoping.builtin.ExecutionEnvironmentDescriptor;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;

public final class GlobalObjectScope
extends EnumerableScope {
    @VisibleForTesting
    public static final String[] FILE_NAMES = new String[]{"global.n4ts"};
    protected static final QualifiedName GLOBAL_OBJECT = QualifiedName.create((String)"GlobalObject");

    public static GlobalObjectScope get(ResourceSet resourceSet) {
        GlobalObjectScopeAccess result = (GlobalObjectScopeAccess)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), GlobalObjectScope.class);
        if (result == null) {
            throw new IllegalStateException("Missing adapter for GlobalObjectScope");
        }
        return result.getScope();
    }

    public TClass getGlobalObject() {
        return (TClass)this.getEObjectOrProxy(GLOBAL_OBJECT);
    }

    public TField getFieldUndefined() {
        TClass globalObject = this.getGlobalObject();
        return globalObject != null ? (TField)globalObject.findOwnedMember("undefined", false, false) : null;
    }

    public GlobalObjectScope(ExecutionEnvironmentDescriptor descriptor) {
        super(descriptor);
    }

    protected String[] getFileNames() {
        return FILE_NAMES;
    }

    protected void buildMap(Resource resource, final Map<QualifiedName, IEObjectDescription> elements) {
        IDefaultResourceDescriptionStrategy strategy = (IDefaultResourceDescriptionStrategy)((XtextResource)resource).getResourceServiceProvider().get(IDefaultResourceDescriptionStrategy.class);
        TreeIterator allProperContents = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
        IAcceptor<IEObjectDescription> acceptor = new IAcceptor<IEObjectDescription>(){

            public void accept(IEObjectDescription description) {
                elements.put(description.getQualifiedName(), description);
            }
        };
        while (allProperContents.hasNext()) {
            EObject content = (EObject)allProperContents.next();
            if (strategy.createEObjectDescriptions(content, (IAcceptor)acceptor)) continue;
            allProperContents.prune();
        }
    }
}

