/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;

public class ProjectDiscoveryHelper {
    @Inject
    NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    @Inject
    ProjectDescriptionLoader projectDescriptionLoader;

    public LinkedHashSet<Path> collectAllProjectDirs(Path ... workspaceRoots) {
        LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        Path[] pathArray = workspaceRoots;
        int n = workspaceRoots.length;
        int n2 = 0;
        while (n2 < n) {
            Path workspaceRoot = pathArray[n2];
            NodeModulesDiscoveryHelper.NodeModulesFolder nodeModulesFolder = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(workspaceRoot);
            if (nodeModulesFolder == null) {
                LinkedHashSet<Path> standAloneProjects = this.collectProjects(workspaceRoot, false);
                allProjectDirs.addAll(standAloneProjects);
            } else if (nodeModulesFolder.isYarnWorkspace) {
                Path yarnProjectDir = nodeModulesFolder.nodeModulesFolder.getParentFile().toPath();
                allProjectDirs.add(yarnProjectDir);
                allProjectDirs.addAll(this.collectYarnWorkspaceProjects(yarnProjectDir));
            } else {
                allProjectDirs.add(workspaceRoot);
            }
            ++n2;
        }
        List<Path> nodeModulesFolders = this.nodeModulesDiscoveryHelper.findNodeModulesFolders(allProjectDirs);
        for (Path nmFolder : nodeModulesFolders) {
            LinkedHashSet<Path> dependencies = this.collectProjects(nmFolder, true);
            allProjectDirs.addAll(dependencies);
        }
        return allProjectDirs;
    }

    private LinkedHashSet<Path> collectYarnWorkspaceProjects(Path yarnProjectRoot) {
        LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        FileURI uri = new FileURI(yarnProjectRoot.toFile());
        List<String> workspaces = this.projectDescriptionLoader.loadWorkspacesFromProjectDescriptionAtLocation(uri);
        for (String workspaceGlob : workspaces) {
            LinkedHashSet<Path> projects = this.collectGlobMatches(workspaceGlob, yarnProjectRoot);
            allProjectDirs.addAll(projects);
        }
        return allProjectDirs;
    }

    private LinkedHashSet<Path> collectProjects(final Path root, boolean includeSubtree) {
        final LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        if (!root.toFile().isDirectory()) {
            return allProjectDirs;
        }
        final FileVisitResult defaultReturn = includeSubtree ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (root.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (dir.endsWith("node_modules")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File pckJson = dir.resolve("package.json").toFile();
                    if (pckJson.isFile()) {
                        if (ProjectDiscoveryHelper.this.nodeModulesDiscoveryHelper.isYarnWorkspaceRoot(dir.toFile())) {
                            allProjectDirs.addAll(ProjectDiscoveryHelper.this.collectYarnWorkspaceProjects(dir));
                        } else {
                            allProjectDirs.add(dir);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return defaultReturn;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return allProjectDirs;
    }

    private LinkedHashSet<Path> collectGlobMatches(String glob, final Path location) {
        final LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + glob);
        try {
            Files.walkFileTree(location, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Path relDir = location.relativize(dir);
                    if (pathMatcher.matches(relDir)) {
                        Path dirName = dir.getName(dir.getNameCount() - 1);
                        if (dirName.toString().startsWith("@")) {
                            allProjectDirs.addAll(ProjectDiscoveryHelper.this.collectProjects(dir, false));
                        } else {
                            File pckJson = dir.resolve("package.json").toFile();
                            if (pckJson.isFile()) {
                                allProjectDirs.add(dir);
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return allProjectDirs;
    }
}

