/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ide.xtext.server.DefaultBuildRequestFactory;
import org.eclipse.n4js.ide.xtext.server.IssueAcceptor;
import org.eclipse.n4js.ide.xtext.server.ProjectStateHolder;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.n4js.ide.xtext.server.build.XIncrementalBuilder;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.internal.lsp.N4JSProjectConfig;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;

public class XProjectManager {
    @Inject
    protected XIncrementalBuilder incrementalBuilder;
    @Inject
    protected Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    protected IFileSystemScanner fileSystemScanner;
    @Inject
    protected IExternalContentSupport externalContentSupport;
    @Inject
    protected DefaultBuildRequestFactory buildRequestFactory;
    @Inject
    protected IssueAcceptor issueAcceptor;
    @Inject
    protected ProjectStateHolder projectStateHolder;
    private URI baseDir;
    private Provider<Map<String, ResourceDescriptionsData>> indexProvider;
    private IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider;
    private XtextResourceSet resourceSet;
    private ProjectDescription projectDescription;
    private IProjectConfig projectConfig;

    public void initialize(ProjectDescription description, IProjectConfig projectConfig, IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider, Provider<Map<String, ResourceDescriptionsData>> indexProvider) {
        this.projectDescription = description;
        this.projectConfig = projectConfig;
        this.baseDir = projectConfig.getPath();
        this.openedDocumentsContentProvider = openedDocumentsContentProvider;
        this.indexProvider = indexProvider;
    }

    public XBuildResult doInitialBuild(CancelIndicator cancelIndicator) {
        Set<URI> changedSources = this.projectStateHolder.readProjectState(this.projectConfig);
        XBuildResult result = this.doIncrementalBuild(changedSources, Collections.emptySet(), Collections.emptyList(), cancelIndicator);
        if (!changedSources.isEmpty()) {
            this.projectStateHolder.writeProjectState(this.projectConfig);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBuildResult doIncrementalBuild(Set<URI> dirtyFiles, Set<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        URI persistanceFile = this.projectStateHolder.getPersistenceFile(this.projectConfig);
        dirtyFiles.remove(persistanceFile);
        deletedFiles.remove(persistanceFile);
        XBuildRequest request = this.newBuildRequest(dirtyFiles, deletedFiles, externalDeltas, cancelIndicator);
        this.resourceSet = request.getResourceSet();
        XBuildResult result = this.incrementalBuilder.build(request);
        this.projectStateHolder.updateProjectState(request, result);
        ResourceDescriptionsData resourceDescriptions = this.projectStateHolder.getIndexState().getResourceDescriptions();
        Map map = (Map)this.indexProvider.get();
        Set set = map.keySet();
        synchronized (set) {
            map.put(this.projectDescription.getName(), resourceDescriptions);
        }
        return result;
    }

    public void reportProjectIssue(String message, String code, Severity severity) {
        Issue.IssueImpl result = new Issue.IssueImpl();
        result.setMessage(message);
        result.setCode(code);
        result.setSeverity(severity);
        result.setUriToProblem(this.baseDir);
        this.issueAcceptor.publishDiagnostics(this.baseDir, (Iterable<? extends Issue>)ImmutableList.of((Object)result));
    }

    public void persistProjectState() {
        this.projectStateHolder.writeProjectState(this.projectConfig);
    }

    protected XBuildRequest newBuildRequest(Set<URI> changedFiles, Set<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        XBuildRequest result = this.buildRequestFactory.getBuildRequest(changedFiles, deletedFiles, externalDeltas);
        XIndexState indexState = this.projectStateHolder.getIndexState();
        ResourceDescriptionsData resourceDescriptionsCopy = indexState.getResourceDescriptions().copy();
        XSource2GeneratedMapping fileMappingsCopy = indexState.getFileMappings().copy();
        result.setState(new XIndexState(resourceDescriptionsCopy, fileMappingsCopy));
        result.setResourceSet(this.createFreshResourceSet(result.getState().getResourceDescriptions()));
        result.setCancelIndicator(cancelIndicator);
        result.setBaseDir(this.baseDir);
        if (this.projectConfig instanceof N4JSProjectConfig) {
            N4JSProjectConfig n4pc = (N4JSProjectConfig)this.projectConfig;
            result.setIndexOnly(n4pc.indexOnly());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XtextResourceSet createFreshResourceSet(ResourceDescriptionsData newIndex) {
        if (this.resourceSet == null) {
            this.resourceSet = this.createNewResourceSet(newIndex);
        } else {
            ChunkedResourceDescriptions resDescs = ChunkedResourceDescriptions.findInEmfObject((Notifier)this.resourceSet);
            Map map = (Map)this.indexProvider.get();
            Set set = map.keySet();
            synchronized (set) {
                for (Map.Entry entry : map.entrySet()) {
                    resDescs.setContainer((String)entry.getKey(), (ResourceDescriptionsData)entry.getValue());
                }
            }
            resDescs.setContainer(this.projectDescription.getName(), newIndex);
        }
        return this.resourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XtextResourceSet createNewResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        this.projectDescription.attachToEmfObject((Notifier)result);
        ProjectConfigAdapter.install((ResourceSet)result, (IProjectConfig)this.projectConfig);
        Map map = (Map)this.indexProvider.get();
        Set set = map.keySet();
        synchronized (set) {
            ChunkedResourceDescriptions index = new ChunkedResourceDescriptions(map, (ResourceSet)result);
            index.setContainer(this.projectDescription.getName(), newIndex);
        }
        this.externalContentSupport.configureResourceSet((ResourceSet)result, this.openedDocumentsContentProvider);
        return result;
    }

    public Resource getResource(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, true);
        resource.getContents();
        return resource;
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    protected Provider<Map<String, ResourceDescriptionsData>> getIndexProvider() {
        return this.indexProvider;
    }

    protected IExternalContentSupport.IExternalContentProvider getOpenedDocumentsContentProvider() {
        return this.openedDocumentsContentProvider;
    }

    public ProjectStateHolder getProjectStateHolder() {
        return this.projectStateHolder;
    }

    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public ProjectDescription getProjectDescription() {
        return this.projectDescription;
    }

    public IProjectConfig getProjectConfig() {
        return this.projectConfig;
    }
}

