/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.validation.Issue;

public class XBuildRequest {
    private URI baseDir;
    private Collection<URI> dirtyFiles = new ArrayList<URI>();
    private Collection<URI> deletedFiles = new ArrayList<URI>();
    private Collection<IResourceDescription.Delta> externalDeltas = new ArrayList<IResourceDescription.Delta>();
    private XIndexState state = new XIndexState();
    private boolean writeStorageResources = false;
    private boolean indexOnly = false;
    private XtextResourceSet resourceSet;
    private CancelIndicator cancelIndicator = CancelIndicator.NullImpl;
    private final Map<URI, Collection<Issue>> resultIssues = new LinkedHashMap<URI, Collection<Issue>>();
    private final Collection<URI> resultDeletedFiles = new ArrayList<URI>();
    private final Map<URI, URI> resultGeneratedFiles = new LinkedHashMap<URI, URI>();
    private AfterValidateListener afterValidateListener;
    private AfterGenerateListener afterGenerateListener;
    private AfterDeleteListener afterDeleteListener;

    public void setBaseDir(URI baseDir) {
        this.baseDir = baseDir;
    }

    public URI getBaseDir() {
        if (this.baseDir == null) {
            String userDir = System.getProperty("user.dir");
            this.baseDir = UriUtil.createFolderURI((File)new File(userDir));
        }
        return this.baseDir;
    }

    public Collection<URI> getDirtyFiles() {
        return this.dirtyFiles;
    }

    public void setDirtyFiles(Collection<URI> dirtyFiles) {
        this.dirtyFiles = dirtyFiles;
    }

    public Collection<URI> getDeletedFiles() {
        return this.deletedFiles;
    }

    public void setDeletedFiles(Collection<URI> deletedFiles) {
        this.deletedFiles = deletedFiles;
    }

    public Collection<IResourceDescription.Delta> getExternalDeltas() {
        return this.externalDeltas;
    }

    public void setExternalDeltas(Collection<IResourceDescription.Delta> externalDeltas) {
        this.externalDeltas = externalDeltas;
    }

    public Map<URI, Collection<Issue>> getResultIssues() {
        return this.resultIssues;
    }

    public void setResultIssues(URI source, Collection<Issue> issues) {
        this.resultIssues.put(source, issues);
        this.afterValidate(source, issues);
    }

    public void setAfterValidateListener(AfterValidateListener afterValidateListener) {
        this.afterValidateListener = afterValidateListener;
    }

    public void afterValidate(URI source, Collection<Issue> issues) {
        if (this.afterValidateListener != null) {
            this.afterValidateListener.afterValidate(source, issues);
        }
    }

    public Map<URI, URI> getResultGeneratedFiles() {
        return this.resultGeneratedFiles;
    }

    public void setResultGeneratedFile(URI source, URI generated) {
        this.resultGeneratedFiles.put(source, generated);
        this.afterGenerate(source, generated);
    }

    public void setAfterGenerateListener(AfterGenerateListener afterGenerateListener) {
        this.afterGenerateListener = afterGenerateListener;
    }

    public void afterGenerate(URI source, URI generated) {
        if (this.afterGenerateListener != null) {
            this.afterGenerateListener.afterGenerate(source, generated);
        }
    }

    public Collection<URI> getResultDeleteFiles() {
        return this.resultDeletedFiles;
    }

    public void setResultDeleteFile(URI file) {
        this.resultDeletedFiles.add(file);
        this.afterDelete(file);
    }

    public void setAfterDeleteListener(AfterDeleteListener afterDeleteListener) {
        this.afterDeleteListener = afterDeleteListener;
    }

    public void afterDelete(URI file) {
        if (this.afterDeleteListener != null) {
            this.afterDeleteListener.afterDelete(file);
        }
    }

    public boolean shouldGenerate(URI source) {
        return !this.containsErrors(source);
    }

    public XIndexState getState() {
        return this.state;
    }

    public void setState(XIndexState state) {
        this.state = state;
    }

    public boolean isWriteStorageResources() {
        return this.writeStorageResources;
    }

    public void setWriteStorageResources(boolean writeStorageResources) {
        this.writeStorageResources = writeStorageResources;
    }

    public boolean isIndexOnly() {
        return this.indexOnly;
    }

    public void setIndexOnly(boolean indexOnly) {
        this.indexOnly = indexOnly;
    }

    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(XtextResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public CancelIndicator getCancelIndicator() {
        return this.cancelIndicator;
    }

    public void setCancelIndicator(CancelIndicator cancelIndicator) {
        this.cancelIndicator = cancelIndicator;
    }

    protected boolean containsErrors(URI source) {
        Collection<Issue> issues = this.resultIssues.get(source);
        for (Issue issue : issues) {
            Severity severity = issue.getSeverity();
            if (severity == null) continue;
            switch (severity) {
                case ERROR: {
                    return true;
                }
                case WARNING: {
                    break;
                }
                case INFO: {
                    break;
                }
            }
        }
        return false;
    }

    public static interface AfterDeleteListener {
        public void afterDelete(URI var1);
    }

    public static interface AfterGenerateListener {
        public void afterGenerate(URI var1, URI var2);
    }

    public static interface AfterValidateListener {
        public void afterValidate(URI var1, Collection<Issue> var2);
    }
}

