/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.compiler;

import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.cli.N4jscConsole;
import org.eclipse.n4js.cli.N4jscException;
import org.eclipse.n4js.cli.N4jscExitCode;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.compiler.N4jscLanguageClient;
import org.eclipse.n4js.ide.xtext.server.DefaultBuildRequestFactory;
import org.eclipse.n4js.ide.xtext.server.ProjectStatePersisterConfig;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.tester.TestCatalogSupplier;
import org.eclipse.xtext.workspace.IProjectConfig;

public class N4jscCompiler {
    private static final Logger LOG = LogManager.getLogger(N4jscCompiler.class);
    private final N4jscOptions options;
    private final XLanguageServerImpl languageServer;
    private final N4jscLanguageClient callback;
    private final XWorkspaceManager workspaceManager;

    public static void start(N4jscOptions options) throws Exception {
        N4jscCompiler compiler = new N4jscCompiler(options);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Measurement m = N4JSDataCollectors.dcCliCompile.getMeasurement(options.toString());){
            compiler.start();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private N4jscCompiler(N4jscOptions options) {
        this.options = options;
        this.languageServer = N4jscFactory.getLanguageServer();
        this.callback = N4jscFactory.getLanguageClient();
        this.workspaceManager = N4jscFactory.getWorkspaceManager();
        this.setPersistionOptions();
        this.languageServer.connect((LanguageClient)this.callback);
        this.setupWorkspaceBuildActionListener();
    }

    public void start() throws Exception {
        InitializeParams params = new InitializeParams();
        File baseDir = this.options.getDir();
        if (baseDir == null) {
            throw new N4jscException(N4jscExitCode.ARGUMENT_DIRS_INVALID, "No base directory");
        }
        params.setRootUri(baseDir.toURI().toString());
        this.languageServer.initialize(params).get();
        this.warnIfNoProjectsFound();
        this.verbosePrintAllProjects();
        switch (this.options.getGoal()) {
            case clean: {
                this.performClean();
                break;
            }
            case compile: {
                this.performCompile();
                break;
            }
        }
        this.languageServer.shutdown();
        this.languageServer.exit();
        this.writeTestCatalog();
    }

    private void performClean() {
        Stopwatch compilationTime = Stopwatch.createStarted();
        this.languageServer.clean();
        this.languageServer.joinCleanFinished();
        this.printCleanResults(compilationTime.stop());
    }

    private void performCompile() {
        if (this.options.isClean()) {
            this.performClean();
            this.callback.resetCounters();
        }
        Stopwatch compilationTime = Stopwatch.createStarted();
        this.languageServer.initialized(new InitializedParams());
        this.languageServer.joinInitBuildFinished();
        this.printCompileResults(compilationTime.stop());
    }

    private void setupWorkspaceBuildActionListener() {
        Injector injector = N4jscFactory.getOrCreateInjector();
        DefaultBuildRequestFactory buildRequestFactory = (DefaultBuildRequestFactory)injector.getInstance(DefaultBuildRequestFactory.class);
        buildRequestFactory.setAfterGenerateListener((XBuildRequest.AfterGenerateListener)this.callback);
        buildRequestFactory.setAfterDeleteListener((XBuildRequest.AfterDeleteListener)this.callback);
    }

    private void setPersistionOptions() {
        Injector injector = N4jscFactory.getOrCreateInjector();
        ProjectStatePersisterConfig persisterConfig = (ProjectStatePersisterConfig)injector.getInstance(ProjectStatePersisterConfig.class);
        persisterConfig.setDeleteState(this.options.isClean());
        persisterConfig.setWriteToDisk(!this.options.isNoPersist());
    }

    private void warnIfNoProjectsFound() {
        Set projects = this.workspaceManager.getWorkspaceConfig().getProjects();
        if (projects.isEmpty()) {
            N4jscConsole.println("No projects found at the given location: " + this.options.getDirs().get(0));
        }
    }

    private void verbosePrintAllProjects() {
        Set projects = this.workspaceManager.getWorkspaceConfig().getProjects();
        int maxPrjNameLength = projects.stream().filter(p -> p.getName() != null).mapToInt(p -> p.getName().length()).max().orElse(10);
        String prjNameWithPadding = "%-" + maxPrjNameLength + "s";
        if (!projects.isEmpty()) {
            Path workspace = this.options.getDirs().get(0).toPath();
            TreeMap<String, String> projectNameList = new TreeMap<String, String>();
            for (IProjectConfig prj : projects) {
                String prjName = prj.getName() == null ? "[no_name]" : prj.getName();
                String locationStr = null;
                if (prj.getPath() == null) {
                    locationStr = "[no_location]";
                } else {
                    locationStr = workspace.relativize(Path.of(prj.getPath().toFileString(), new String[0])).toString();
                    if (locationStr.isBlank()) {
                        locationStr = ".";
                    }
                }
                String outputLine = String.format(String.valueOf(prjNameWithPadding) + " at %s", prjName, locationStr);
                projectNameList.put(locationStr, outputLine);
            }
            LOG.info((Object)(String.valueOf(projects.size()) + " projects: \n   " + String.join((CharSequence)"\n   ", projectNameList.values())));
        }
    }

    private void printCleanResults(Stopwatch elapsedTime) {
        long deltd = this.callback.getDeletionsCount();
        String durationStr = elapsedTime.toString();
        String msg = String.format("Clean results - Deleted: %d, Duration: %s", deltd, durationStr);
        N4jscConsole.println(msg);
    }

    private void printCompileResults(Stopwatch elapsedTime) {
        long trsnp = this.callback.getTranspilationsCount();
        long deltd = this.callback.getDeletionsCount();
        long errs = this.callback.getErrorsCount();
        long wrns = this.callback.getWarningsCount();
        String durationStr = elapsedTime.toString();
        String msg = String.format("Compile results - Transpiled: %d, Deleted: %d, Errors: %d, Warnings: %d, Duration: %s", trsnp, deltd, errs, wrns, durationStr);
        N4jscConsole.println(msg);
    }

    private void writeTestCatalog() throws N4jscException {
        File testCatalogFile = this.options.getTestCatalog();
        if (testCatalogFile != null) {
            Injector injector = N4jscFactory.getOrCreateInjector();
            TestCatalogSupplier testCatalogSupplier = (TestCatalogSupplier)injector.getInstance(TestCatalogSupplier.class);
            String catalog = testCatalogSupplier.get(true);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileOutputStream fos = new FileOutputStream(testCatalogFile);){
                    fos.write(catalog.getBytes());
                    fos.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                String msg = "Error while writing test catalog file at: " + testCatalogFile;
                throw new N4jscException(N4jscExitCode.TEST_CATALOG_ASSEMBLATION_ERROR, msg);
            }
            N4jscConsole.println("Test catalog written to " + testCatalogFile.toPath());
        }
    }
}

