/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.HashedFileContent;
import org.eclipse.n4js.ide.xtext.server.IssueAcceptor;
import org.eclipse.n4js.ide.xtext.server.ProjectStatePersister;
import org.eclipse.n4js.ide.xtext.server.ProjectStatePersisterConfig;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;

public class ProjectStateHolder {
    @Inject
    protected ProjectStatePersister projectStatePersister;
    @Inject
    protected IFileSystemScanner fileSystemScanner;
    @Inject
    protected IssueAcceptor issueAcceptor;
    @Inject
    protected ProjectStatePersisterConfig persistConfig;
    private XIndexState indexState = new XIndexState();
    private Map<URI, HashedFileContent> hashFileMap = new HashMap<URI, HashedFileContent>();
    private final Map<URI, Collection<Issue>> validationIssues = new HashMap<URI, Collection<Issue>>();

    public void doClear() {
        this.hashFileMap.clear();
        this.setIndexState(new XIndexState());
        this.validationIssues.clear();
    }

    public void deletePersistenceFile(IProjectConfig projectConfig) {
        URI persistenceFileURI = this.getPersistenceFile(projectConfig);
        File persistenceFile = new File(persistenceFileURI.toFileString());
        if (persistenceFile.isFile()) {
            persistenceFile.delete();
        }
    }

    public void writeProjectState(IProjectConfig projectConfig) {
        if (this.persistConfig.isWriteToDisk(projectConfig) && !this.hashFileMap.isEmpty()) {
            Collection<HashedFileContent> hashFileContents = this.hashFileMap.values();
            this.projectStatePersister.writeProjectState(projectConfig, this.indexState, hashFileContents, this.validationIssues);
        }
    }

    public Set<URI> readProjectState(IProjectConfig projectConfig) {
        if (this.persistConfig.isDeleteState(projectConfig)) {
            this.deletePersistenceFile(projectConfig);
        }
        HashSet<URI> changedSources = new HashSet<URI>();
        this.doClear();
        ProjectStatePersister.PersistedState persistedState = this.projectStatePersister.readProjectState(projectConfig);
        if (persistedState != null) {
            for (HashedFileContent hfc : persistedState.fileHashs.values()) {
                URI uri = hfc.getUri();
                if (this.isSourceUnchanged(hfc, persistedState)) {
                    this.hashFileMap.put(uri, hfc);
                    continue;
                }
                persistedState.indexState.getFileMappings().deleteSource(uri);
                persistedState.validationIssues.remove(uri);
            }
            this.setIndexState(persistedState.indexState);
            this.mergeValidationIssues(persistedState.validationIssues);
            this.reportValidationIssues(persistedState.validationIssues);
        }
        Set allIndexedUris = this.indexState.getResourceDescriptions().getAllURIs();
        for (ISourceFolder srcFolder : projectConfig.getSourceFolders()) {
            List allSourceFolderUris = srcFolder.getAllResources(this.fileSystemScanner);
            for (URI srcFolderUri : allSourceFolderUris) {
                if (allIndexedUris.contains(srcFolderUri)) continue;
                changedSources.add(srcFolderUri);
            }
        }
        return changedSources;
    }

    public void updateProjectState(XBuildRequest request, XBuildResult result) {
        HashMap<URI, HashedFileContent> newFileContents = new HashMap<URI, HashedFileContent>(this.hashFileMap);
        for (IResourceDescription.Delta delta : result.getAffectedResources()) {
            URI uri = delta.getUri();
            this.storeHash(newFileContents, uri);
        }
        for (URI deletedFile : request.getResultDeleteFiles()) {
            newFileContents.remove(deletedFile);
        }
        this.setIndexState(result.getIndexState());
        this.mergeValidationIssues(request.getResultIssues());
        this.hashFileMap = newFileContents;
    }

    private boolean isSourceUnchanged(HashedFileContent hfc, ProjectStatePersister.PersistedState persistedState) {
        URI sourceUri = hfc.getUri();
        long loadedHash = hfc.getHash();
        HashedFileContent newHash = this.doHash(sourceUri);
        if (newHash == null || loadedHash != newHash.getHash()) {
            return false;
        }
        XSource2GeneratedMapping sourceFileMappings = persistedState.indexState.getFileMappings();
        List<URI> prevGenerated = sourceFileMappings.getGenerated(sourceUri);
        for (URI generated : prevGenerated) {
            HashedFileContent generatedHash;
            HashedFileContent genFingerprint = persistedState.fileHashs.get(generated);
            if (genFingerprint == null || (generatedHash = this.doHash(generated)) != null && generatedHash.getHash() == genFingerprint.getHash()) continue;
            return false;
        }
        return true;
    }

    private HashedFileContent doHash(URI uri) {
        try {
            File srcFile = new File(new java.net.URI(uri.toString()));
            HashedFileContent generatedTargetContent = new HashedFileContent(uri, srcFile);
            return generatedTargetContent;
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }

    private void storeHash(HashMap<URI, HashedFileContent> newFileContents, URI uri) {
        HashedFileContent generatedTargetContent = this.doHash(uri);
        if (generatedTargetContent != null) {
            newFileContents.put(uri, generatedTargetContent);
        }
    }

    private void reportValidationIssues(Map<URI, ? extends Collection<Issue>> valIssues) {
        for (Map.Entry<URI, ? extends Collection<Issue>> srcIssues : valIssues.entrySet()) {
            URI source = srcIssues.getKey();
            Collection<Issue> issues = srcIssues.getValue();
            this.issueAcceptor.publishDiagnostics(source, issues);
        }
    }

    public URI getPersistenceFile(IProjectConfig projectConfig) {
        URI persistanceFile = this.projectStatePersister.getFileName(projectConfig);
        return persistanceFile;
    }

    public XIndexState getIndexState() {
        return this.indexState;
    }

    protected void setIndexState(XIndexState indexState) {
        this.indexState = indexState;
    }

    protected void mergeValidationIssues(Map<URI, Collection<Issue>> issueMap) {
        for (Map.Entry<URI, Collection<Issue>> entry : issueMap.entrySet()) {
            URI source = entry.getKey();
            Collection<Issue> issues = entry.getValue();
            if (issues.isEmpty()) {
                this.validationIssues.remove(source);
                continue;
            }
            this.validationIssues.put(source, issues);
        }
    }
}

