/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.xpect.ui.N4IDEXpectUIPlugin;
import org.eclipse.n4js.xpect.ui.results.N4IDEXpectCompareEditorInput;
import org.eclipse.n4js.xpect.ui.results.N4IDEXpectView;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectTestFilesCollector;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.XpectRunner;
import org.junit.ComparisonFailure;
import org.junit.runner.Description;

public class XpectCompareCommandHandler
extends AbstractHandler {
    private N4IDEXpectView view;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Throwable failureException;
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        IWorkbenchWindow[] windows = N4IDEXpectUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        try {
            this.view = (N4IDEXpectView)windows[0].getActivePage().showView("org.eclipse.n4js.xpect.ui.runner.N4IDEXpectView");
        }
        catch (PartInitException e) {
            N4IDEXpectUIPlugin.logError("cannot refresh test view window", e);
        }
        Description desc = (Description)selection.getFirstElement();
        if (desc.isTest() && this.view.testsExecutionStatus.hasFailed(desc) && (failureException = this.view.testsExecutionStatus.getFailure(desc).getException()) instanceof ComparisonFailure) {
            ComparisonFailure cf = (ComparisonFailure)failureException;
            this.displayComparisonView(cf, desc);
        }
        return null;
    }

    private void displayComparisonView(ComparisonFailure cf, Description desc) {
        IXpectURIProvider uriProfider = XpectRunner.INSTANCE.getUriProvider();
        IFile fileTest = null;
        if (uriProfider instanceof N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider) {
            N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider fileCollector = (N4IDEXpectTestFilesCollector.N4IDEXpectTestURIProvider)uriProfider;
            fileTest = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileCollector.findRawLocation(desc)));
        }
        if (fileTest == null || !fileTest.isAccessible()) {
            throw new RuntimeException("paths in descriptions changed!");
        }
        N4IDEXpectCompareEditorInput inp = new N4IDEXpectCompareEditorInput(fileTest, cf);
        CompareUI.openCompareEditor((CompareEditorInput)inp);
    }
}

