/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.n4js.ide.xtext.server.DefaultBuildRequestFactory;
import org.eclipse.n4js.ide.xtext.server.IssueAcceptor;
import org.eclipse.n4js.ide.xtext.server.ProjectStateHolder;
import org.eclipse.n4js.ide.xtext.server.ProjectUriResourceMap;
import org.eclipse.n4js.ide.xtext.server.WorkspaceAwareResourceLocator;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.n4js.ide.xtext.server.build.XIncrementalBuilder;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.internal.lsp.N4JSProjectConfig;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;

public class XProjectManager {
    @Inject
    protected XIncrementalBuilder incrementalBuilder;
    @Inject
    protected Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    protected IFileSystemScanner fileSystemScanner;
    @Inject
    protected IExternalContentSupport externalContentSupport;
    @Inject
    protected DefaultBuildRequestFactory buildRequestFactory;
    @Inject
    protected IssueAcceptor issueAcceptor;
    @Inject
    protected ProjectStateHolder projectStateHolder;
    @Inject
    protected OutputConfigurationProvider outputConfigProvider;
    @Inject
    protected OperationCanceledManager operationCanceledManager;
    @Inject
    protected ProjectUriResourceMap uriResourceMap;
    @Inject
    protected XWorkspaceManager workspaceManager;
    private URI baseDir;
    private Provider<Map<String, ResourceDescriptionsData>> indexProvider;
    private IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider;
    private XtextResourceSet resourceSet;
    private ProjectDescription projectDescription;
    private IProjectConfig projectConfig;
    private boolean mustWriteProjectState = false;

    public void initialize(ProjectDescription description, IProjectConfig projectConfig, IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider, Provider<Map<String, ResourceDescriptionsData>> indexProvider) {
        this.projectDescription = description;
        this.projectConfig = projectConfig;
        this.baseDir = projectConfig.getPath();
        this.openedDocumentsContentProvider = openedDocumentsContentProvider;
        this.indexProvider = indexProvider;
        this.resourceSet = this.createNewResourceSet(new XIndexState().getResourceDescriptions());
    }

    public XBuildResult doInitialBuild(CancelIndicator cancelIndicator) {
        Set<URI> changedSources = this.projectStateHolder.readProjectState(this.projectConfig);
        XBuildResult result = this.doIncrementalBuild(changedSources, Collections.emptySet(), Collections.emptyList(), cancelIndicator);
        boolean wasDeliver = this.resourceSet.eDeliver();
        try {
            this.resourceSet.eSetDeliver(false);
            this.resourceSet.getResources().clear();
        }
        finally {
            this.resourceSet.eSetDeliver(wasDeliver);
        }
        this.persistProjectState();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBuildResult doIncrementalBuild(Set<URI> dirtyFiles, Set<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        URI persistenceFile = this.projectStateHolder.getPersistenceFile(this.projectConfig);
        dirtyFiles.remove(persistenceFile);
        deletedFiles.remove(persistenceFile);
        XBuildRequest request = this.newBuildRequest(dirtyFiles, deletedFiles, externalDeltas, cancelIndicator);
        this.resourceSet = request.getResourceSet();
        XBuildResult result = this.incrementalBuilder.build(request);
        this.projectStateHolder.updateProjectState(request, result);
        ResourceDescriptionsData resourceDescriptions = this.projectStateHolder.getIndexState().getResourceDescriptions();
        Map map = (Map)this.indexProvider.get();
        Set set = map.keySet();
        synchronized (set) {
            map.put(this.projectDescription.getName(), resourceDescriptions);
        }
        this.mustWriteProjectState |= !result.getAffectedResources().isEmpty();
        return result;
    }

    public void doClean(CancelIndicator cancelIndicator) {
        N4JSProjectConfig n4pc;
        this.projectStateHolder.deletePersistenceFile(this.projectConfig);
        if (this.projectConfig instanceof N4JSProjectConfig && !(n4pc = (N4JSProjectConfig)this.projectConfig).canClean()) {
            return;
        }
        XBuildRequest request = this.buildRequestFactory.getBuildRequest();
        for (File outputDirectory : this.getOutputDirectories()) {
            File[] childFildes = outputDirectory.listFiles();
            if (childFildes != null) {
                int i = 0;
                while (i < childFildes.length) {
                    this.deleteFileOrFolder(request, childFildes[i]);
                    ++i;
                }
            }
            this.operationCanceledManager.checkCanceled(cancelIndicator);
        }
    }

    public List<File> getOutputDirectories() {
        ArrayList<File> outputDirs = new ArrayList<File>();
        Set outputConfigurations = this.outputConfigProvider.getOutputConfigurations((ResourceSet)this.resourceSet);
        URI projectBaseUri = this.projectConfig.getPath();
        for (OutputConfiguration outputConf : outputConfigurations) {
            for (String outputDirName : outputConf.getOutputDirectories()) {
                URI outputUri = projectBaseUri.appendSegment(outputDirName);
                File outputDirectory = new File(outputUri.toFileString());
                outputDirs.add(outputDirectory);
            }
        }
        return outputDirs;
    }

    protected void deleteFileOrFolder(XBuildRequest request, File file) {
        if (file.isDirectory()) {
            File[] childFildes = file.listFiles();
            int i = 0;
            while (i < childFildes.length) {
                this.deleteFileOrFolder(request, childFildes[i]);
                ++i;
            }
        }
        boolean wasFile = file.isFile();
        file.delete();
        if (wasFile) {
            URI fileUri = URI.createFileURI((String)file.getAbsolutePath());
            request.afterDelete(fileUri);
        }
    }

    public void reportProjectIssue(String message, String code, Severity severity) {
        Issue.IssueImpl result = new Issue.IssueImpl();
        result.setMessage(message);
        result.setCode(code);
        result.setSeverity(severity);
        result.setUriToProblem(this.baseDir);
        this.issueAcceptor.publishDiagnostics(this.baseDir, (Iterable<? extends Issue>)ImmutableList.of((Object)result));
    }

    public void persistProjectState() {
        if (this.mustWriteProjectState) {
            this.projectStateHolder.writeProjectState(this.projectConfig);
            this.mustWriteProjectState = false;
        }
    }

    protected XBuildRequest newBuildRequest(Set<URI> changedFiles, Set<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        XBuildRequest result = this.buildRequestFactory.getBuildRequest(changedFiles, deletedFiles, externalDeltas);
        XIndexState indexState = this.projectStateHolder.getIndexState();
        ResourceDescriptionsData resourceDescriptionsCopy = indexState.getResourceDescriptions().copy();
        XSource2GeneratedMapping fileMappingsCopy = indexState.getFileMappings().copy();
        result.setState(new XIndexState(resourceDescriptionsCopy, fileMappingsCopy));
        result.setResourceSet(this.createFreshResourceSet(result.getState().getResourceDescriptions()));
        result.setCancelIndicator(cancelIndicator);
        result.setBaseDir(this.baseDir);
        if (this.projectConfig instanceof N4JSProjectConfig) {
            N4JSProjectConfig n4pc = (N4JSProjectConfig)this.projectConfig;
            result.setIndexOnly(n4pc.indexOnly());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XtextResourceSet createFreshResourceSet(ResourceDescriptionsData newIndex) {
        if (this.resourceSet == null) {
            this.resourceSet = this.createNewResourceSet(newIndex);
        } else {
            ChunkedResourceDescriptions resDescs = ChunkedResourceDescriptions.findInEmfObject((Notifier)this.resourceSet);
            Map map = (Map)this.indexProvider.get();
            Set set = map.keySet();
            synchronized (set) {
                for (Map.Entry entry : map.entrySet()) {
                    resDescs.setContainer((String)entry.getKey(), (ResourceDescriptionsData)entry.getValue());
                }
            }
            resDescs.setContainer(this.projectDescription.getName(), newIndex);
        }
        return this.resourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XtextResourceSet createNewResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        result.setURIResourceMap((Map)((Object)this.uriResourceMap));
        this.projectDescription.attachToEmfObject((Notifier)result);
        ProjectConfigAdapter.install((ResourceSet)result, (IProjectConfig)this.projectConfig);
        this.attachWorkspaceResourceLocator(result);
        Map map = (Map)this.indexProvider.get();
        Set set = map.keySet();
        synchronized (set) {
            ChunkedResourceDescriptions index = new ChunkedResourceDescriptions(map, (ResourceSet)result);
            index.setContainer(this.projectDescription.getName(), newIndex);
        }
        this.externalContentSupport.configureResourceSet((ResourceSet)result, this.openedDocumentsContentProvider);
        return result;
    }

    private WorkspaceAwareResourceLocator attachWorkspaceResourceLocator(XtextResourceSet result) {
        return new WorkspaceAwareResourceLocator((ResourceSetImpl)result, this.workspaceManager);
    }

    public Resource getResource(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, true);
        resource.getContents();
        return resource;
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    protected Provider<Map<String, ResourceDescriptionsData>> getIndexProvider() {
        return this.indexProvider;
    }

    protected IExternalContentSupport.IExternalContentProvider getOpenedDocumentsContentProvider() {
        return this.openedDocumentsContentProvider;
    }

    public ProjectStateHolder getProjectStateHolder() {
        return this.projectStateHolder;
    }

    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public ProjectDescription getProjectDescription() {
        return this.projectDescription;
    }

    public IProjectConfig getProjectConfig() {
        return this.projectConfig;
    }
}

