/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.UserdataMapper;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

@Singleton
public class CanLoadFromDescriptionHelper {
    @Inject
    private IN4JSCore n4jsCore;

    public boolean isLoadFromSourceDeactivated() {
        return true;
    }

    public boolean canLoadFromDescription(URI resourceURI, ResourceSet resourceSet) {
        return !this.mustLoadFromSource(resourceURI, resourceSet);
    }

    public boolean mustLoadFromSource(URI resourceURI, ResourceSet resourceSet) {
        if (this.isLoadFromSourceDeactivated()) {
            return false;
        }
        Resource knownResource = resourceSet.getResource(resourceURI, false);
        if (knownResource != null) {
            return false;
        }
        HashSet sourceURIs = Sets.newHashSet();
        EList listOfResources = resourceSet.getResources();
        int i = 0;
        int size = listOfResources.size();
        while (i < size) {
            N4JSResource casted;
            Resource existingResource = (Resource)listOfResources.get(i);
            if (existingResource instanceof N4JSResource && !(casted = (N4JSResource)existingResource).isLoadedFromDescription()) {
                sourceURIs.add(casted.getURI());
            }
            ++i;
        }
        return this.dependsOnAny(resourceURI, sourceURIs, this.getIndex(resourceSet), true);
    }

    public boolean dependsOnAny(Resource resource, Set<URI> others) {
        return this.dependsOnAny(resource.getURI(), others, this.getIndex(resource.getResourceSet()), false);
    }

    protected IResourceDescriptions getIndex(ResourceSet resourceSet) {
        return this.n4jsCore.getXtextIndex(resourceSet);
    }

    public boolean isPartOfDependencyCycle(URI thisURI, IResourceDescriptions index) {
        return this.dependsOnAny(thisURI, Collections.singleton(thisURI), index, true);
    }

    protected boolean dependsOnAny(URI thisURI, Set<URI> candidates, IResourceDescriptions index, boolean considerOnlySameProject) {
        IN4JSProject thisProject = null;
        if (considerOnlySameProject && !candidates.isEmpty()) {
            thisProject = (IN4JSProject)this.n4jsCore.findProject(thisURI).orNull();
            candidates = this.filterCandidatesByProject(candidates, thisProject);
        }
        if (candidates.isEmpty()) {
            return false;
        }
        HashSet visited = Sets.newHashSet();
        ArrayDeque<URI> queue = new ArrayDeque<URI>();
        queue.add(thisURI);
        while (!queue.isEmpty()) {
            Optional<List<String>> dependencies = this.readDirectDependencies(index, (URI)queue.poll());
            if (!dependencies.isPresent()) {
                return true;
            }
            for (String dependency : dependencies.get()) {
                URI dependencyURI = URI.createURI((String)dependency);
                if (!visited.add(dependencyURI) || considerOnlySameProject && !this.projectContainsURI(thisProject, dependencyURI)) continue;
                if (candidates.contains(dependencyURI)) {
                    return true;
                }
                queue.add(dependencyURI);
            }
        }
        return false;
    }

    private Set<URI> filterCandidatesByProject(Set<URI> candidates, IN4JSProject project) {
        if (project == null) {
            return Collections.emptySet();
        }
        return FluentIterable.from(candidates).filter(candidate -> this.projectContainsURI(project, (URI)candidate)).toSet();
    }

    private boolean projectContainsURI(IN4JSProject project, URI candidate) {
        return project.equals(this.n4jsCore.findProject(candidate).orNull());
    }

    private Optional<List<String>> readDirectDependencies(IResourceDescriptions index, URI next) {
        IResourceDescription description = index.getResourceDescription(next);
        return Optional.ofNullable(description).flatMap(UserdataMapper::readDependenciesFromDescription);
    }

    public Resource createResource(ResourceSet resourceSet, URI resourceURI) {
        return resourceSet.createResource(resourceURI);
    }
}

