/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.generator.headless.HeadlessHelper;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.ide.xtext.server.XIWorkspaceConfigFactory;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.lsp.N4JSWorkspaceConfig;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.ProjectDiscoveryHelper;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

@Singleton
public class FileBasedWorkspaceInitializer
implements XIWorkspaceConfigFactory {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private HeadlessHelper headlessHelper;
    @Inject
    private FileBasedWorkspace workspace;
    @Inject
    private ProjectDiscoveryHelper projectDiscoveryHelper;

    @Override
    public IWorkspaceConfig getWorkspaceConfig(URI workspaceBaseURI) {
        try {
            this.workspace.clear();
            File workspaceRoot = new File(workspaceBaseURI.toFileString());
            LinkedHashSet allProjectLocations = this.projectDiscoveryHelper.collectAllProjectDirs(new Path[]{workspaceRoot.toPath()});
            LinkedList<FileURI> allProjectURIs = new LinkedList<FileURI>();
            for (Path path : allProjectLocations) {
                allProjectURIs.add(new FileURI(path.toFile()));
            }
            this.headlessHelper.registerProjectsToFileBasedWorkspace(allProjectURIs, this.workspace);
            return new N4JSWorkspaceConfig(this.n4jsCore);
        }
        catch (N4JSCompileException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

