/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.validation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class N4JSIssue
extends Issue.IssueImpl
implements Externalizable {
    private static final String NULL = "";
    private int lineNumberEnd;
    private int columnEnd;
    private static final Severity[] severities = Severity.values();
    private static final CheckType[] checkTypes = CheckType.values();

    public N4JSIssue() {
        this.setOffset(0);
        this.setLength(0);
        this.setColumn(0);
        this.setColumnEnd(0);
        this.setLineNumber(0);
        this.setLineNumberEnd(0);
        this.setCode(NULL);
        this.setMessage(NULL);
        this.setUriToProblem(null);
        this.setSeverity(Severity.IGNORE);
        this.setType(CheckType.FAST);
    }

    public int getLineNumberEnd() {
        return this.lineNumberEnd;
    }

    public void setLineNumberEnd(int lineNumberEnd) {
        this.lineNumberEnd = lineNumberEnd;
    }

    public int getColumnEnd() {
        return this.columnEnd;
    }

    public void setColumnEnd(int columnEnd) {
        this.columnEnd = columnEnd;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.getOffset());
        out.writeInt(this.getLength());
        out.writeInt(this.getColumn());
        out.writeInt(this.getColumnEnd());
        out.writeInt(this.getLineNumber());
        out.writeInt(this.getLineNumberEnd());
        out.writeUTF(this.getCode());
        out.writeUTF(this.getMessage());
        URI uriToProblem = this.getUriToProblem();
        String uriToProblemStr = uriToProblem == null ? NULL : uriToProblem.toString();
        out.writeUTF(uriToProblemStr);
        Severity severity = this.getSeverity();
        int severityKey = severity == null ? 0 : severity.ordinal() + 1;
        out.writeInt(severityKey);
        CheckType checkType = this.getType();
        int checkTypeKey = checkType == null ? 0 : checkType.ordinal() + 1;
        out.writeInt(checkTypeKey);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setOffset(in.readInt());
        this.setLength(in.readInt());
        this.setColumn(in.readInt());
        this.setColumnEnd(in.readInt());
        this.setLineNumber(in.readInt());
        this.setLineNumberEnd(in.readInt());
        this.setCode(in.readUTF());
        this.setMessage(in.readUTF());
        String uriToProblemStr = in.readUTF();
        URI uriToProblem = NULL.equals(uriToProblemStr) ? null : URI.createURI((String)uriToProblemStr);
        this.setUriToProblem(uriToProblem);
        int severityKey = in.readInt();
        Severity severity = N4JSIssue.severityFromKey(severityKey);
        this.setSeverity(severity);
        int checkTypeKey = in.readInt();
        CheckType checkType = N4JSIssue.checkTypeFromKey(checkTypeKey);
        this.setType(checkType);
    }

    private static Severity severityFromKey(int severityKey) {
        switch (severityKey) {
            case 0: {
                return null;
            }
        }
        return severities[severityKey - 1];
    }

    private static CheckType checkTypeFromKey(int checkTypeKey) {
        switch (checkTypeKey) {
            case 0: {
                return null;
            }
        }
        return checkTypes[checkTypeKey - 1];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof N4JSIssue)) {
            return false;
        }
        N4JSIssue n4Issue = (N4JSIssue)obj;
        boolean equals = true;
        equals &= Objects.equals(n4Issue.getCode(), this.getCode());
        equals &= Objects.equals(n4Issue.getLength(), this.getLength());
        equals &= Objects.equals(n4Issue.getColumn(), this.getColumn());
        equals &= n4Issue.getColumnEnd() == this.getColumnEnd();
        equals &= Objects.equals(n4Issue.getLineNumber(), this.getLineNumber());
        equals &= n4Issue.getLineNumberEnd() == this.getLineNumberEnd();
        equals &= Objects.equals(n4Issue.getCode(), this.getCode());
        equals &= Objects.equals(n4Issue.getMessage(), this.getMessage());
        equals &= n4Issue.getUriToProblem() == this.getUriToProblem();
        equals &= n4Issue.getSeverity() == this.getSeverity();
        return equals &= n4Issue.getType() == this.getType();
    }

    public int hashCode() {
        return Objects.hash(this.getCode(), this.getLength(), this.getColumn(), this.getColumnEnd(), this.getLineNumber(), this.getLineNumberEnd(), this.getCode(), this.getMessage(), this.getUriToProblem(), this.getSeverity(), this.getType());
    }
}

