/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.validation.N4JSIssue;
import org.eclipse.n4js.ide.xtext.server.HashedFileContent;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;

public class ProjectStatePersister {
    private static final int VERSION_1 = 1;
    private static final int CURRENT_VERSION = 1;
    public static final String FILENAME = ".n4js.projectstate";

    public void writeProjectState(IProjectConfig project, XIndexState state, Collection<? extends HashedFileContent> files, Map<URI, ? extends Collection<Issue>> validationIssues) {
        try {
            File file = this.getDataFile(project);
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (OutputStream nativeOut = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();){
                    this.writeProjectState(nativeOut, N4JSLanguageUtils.getLanguageVersion(), state, files, validationIssues);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (file.isFile()) {
                    file.delete();
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void writeProjectState(OutputStream stream, String languageVersion, XIndexState state, Collection<? extends HashedFileContent> files, Map<URI, ? extends Collection<Issue>> validationIssues) throws IOException {
        stream.write(1);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream, 8192)));){
            output.writeUTF(languageVersion);
            this.writeResourceDescriptions(state, output);
            this.writeFileMappings(state, output);
            this.writeFingerprints(files, output);
            this.writeValidationIssues(validationIssues, output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeResourceDescriptions(XIndexState state, ObjectOutputStream output) throws IOException {
        ResourceDescriptionsData resourceDescriptionData = state.getResourceDescriptions();
        output.writeInt(resourceDescriptionData.getAllURIs().size());
        for (IResourceDescription description : resourceDescriptionData.getAllResourceDescriptions()) {
            if (description instanceof SerializableResourceDescription) {
                ((SerializableResourceDescription)description).writeExternal((ObjectOutput)output);
                continue;
            }
            throw new IOException("Unexpected type: " + description.getClass().getName());
        }
    }

    private void writeFileMappings(XIndexState state, ObjectOutputStream output) throws IOException {
        state.getFileMappings().writeExternal(output);
    }

    private void writeFingerprints(Collection<? extends HashedFileContent> files, ObjectOutputStream output) throws IOException {
        output.writeInt(files.size());
        for (HashedFileContent hashedFileContent : files) {
            hashedFileContent.write(output);
        }
    }

    private void writeValidationIssues(Map<URI, ? extends Collection<Issue>> validationIssues, ObjectOutput output) throws IOException {
        int numberSources = validationIssues.size();
        output.writeInt(numberSources);
        for (Map.Entry<URI, ? extends Collection<Issue>> srcIssues : validationIssues.entrySet()) {
            URI source = srcIssues.getKey();
            Collection<Issue> issues = srcIssues.getValue();
            output.writeUTF(source.toString());
            ArrayList<N4JSIssue> n4Issues = new ArrayList<N4JSIssue>();
            for (Issue issue : issues) {
                if (!(issue instanceof N4JSIssue)) continue;
                n4Issues.add((N4JSIssue)issue);
            }
            int numberIssues = n4Issues.size();
            output.writeInt(numberIssues);
            for (N4JSIssue issue : n4Issues) {
                issue.writeExternal(output);
            }
        }
    }

    public PersistedState readProjectState(IProjectConfig project) {
        try {
            File file = this.getDataFile(project);
            try {
                if (file.isFile()) {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (InputStream nativeIn = Files.asByteSource((File)file).openBufferedStream();){
                        return this.readProjectState(nativeIn, N4JSLanguageUtils.getLanguageVersion());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException | ClassNotFoundException e) {
                if (file.isFile()) {
                    file.delete();
                }
            }
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistedState readProjectState(InputStream stream, String expectedLanguageVersion) throws IOException, ClassNotFoundException {
        int version = stream.read();
        if (version != 1) {
            return null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(stream, 8192)));){
            String languageVersion = input.readUTF();
            if (!expectedLanguageVersion.equals(languageVersion)) {
                return null;
            }
            ResourceDescriptionsData resourceDescriptionsData = this.readResourceDescriptions(input);
            XSource2GeneratedMapping fileMappings = this.readFileMappings(input);
            Map<URI, HashedFileContent> fingerprints = this.readFingerprints(input);
            Map<URI, Collection<Issue>> validationIssues = this.readValidationIssues(input);
            XIndexState indexState = new XIndexState(resourceDescriptionsData, fileMappings);
            return new PersistedState(indexState, fingerprints, validationIssues);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private ResourceDescriptionsData readResourceDescriptions(ObjectInputStream input) throws IOException, ClassNotFoundException {
        ArrayList<SerializableResourceDescription> descriptions = new ArrayList<SerializableResourceDescription>();
        int size = input.readInt();
        while (size > 0) {
            --size;
            SerializableResourceDescription description = new SerializableResourceDescription();
            description.readExternal((ObjectInput)input);
            descriptions.add(description);
        }
        ResourceDescriptionsData resourceDescriptionsData = new ResourceDescriptionsData(descriptions);
        return resourceDescriptionsData;
    }

    private XSource2GeneratedMapping readFileMappings(ObjectInputStream input) throws IOException, ClassNotFoundException {
        XSource2GeneratedMapping fileMappings = new XSource2GeneratedMapping();
        fileMappings.readExternal(input);
        return fileMappings;
    }

    private Map<URI, HashedFileContent> readFingerprints(ObjectInputStream input) throws IOException {
        HashMap<URI, HashedFileContent> fingerprints = new HashMap<URI, HashedFileContent>();
        int size = input.readInt();
        while (size > 0) {
            --size;
            HashedFileContent hashFileContent = new HashedFileContent(input);
            fingerprints.put(hashFileContent.getUri(), hashFileContent);
        }
        return fingerprints;
    }

    private Map<URI, Collection<Issue>> readValidationIssues(ObjectInputStream input) throws IOException, ClassNotFoundException {
        LinkedHashMap<URI, Collection<Issue>> validationIssues = new LinkedHashMap<URI, Collection<Issue>>();
        int numberOfSources = input.readInt();
        while (numberOfSources > 0) {
            --numberOfSources;
            URI source = URI.createURI((String)input.readUTF());
            validationIssues.put(source, new ArrayList());
            int numberOfIssues = input.readInt();
            while (numberOfIssues > 0) {
                --numberOfIssues;
                N4JSIssue issue = new N4JSIssue();
                issue.readExternal(input);
                ((Collection)validationIssues.get(source)).add(issue);
            }
        }
        return validationIssues;
    }

    private File getDataFile(IProjectConfig project) throws URISyntaxException {
        URI fileName = this.getFileName(project);
        File file = new File(new java.net.URI(fileName.toString()));
        return file;
    }

    public URI getFileName(IProjectConfig project) {
        URI rootPath = project.getPath();
        URI fileName = rootPath.appendSegment(FILENAME);
        return fileName;
    }

    public static class PersistedState {
        public final XIndexState indexState;
        public final Map<URI, HashedFileContent> fileHashs;
        public final Map<URI, Collection<Issue>> validationIssues;

        PersistedState(XIndexState indexState, Map<URI, HashedFileContent> fileHashs, Map<URI, Collection<Issue>> validationIssues) {
            this.indexState = indexState;
            this.fileHashs = fileHashs;
            this.validationIssues = validationIssues;
        }
    }
}

