/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

public class GeneratedJSFilesCounter {
    public static TreeMap<Path, HashSet<File>> getTranspiledFiles(final Path workspaceRoot) {
        final AtomicReference genFilesRef = new AtomicReference();
        File n4jsLibrariesRoot = GeneratedJSFilesCounter.findN4jsLibRoot();
        if (n4jsLibrariesRoot == null) {
            System.out.println("Folder not found: n4js-libs/packages");
            return (TreeMap)genFilesRef.get();
        }
        final HashSet<String> n4jsLibraryNames = new HashSet<String>(Arrays.asList(n4jsLibrariesRoot.list()));
        genFilesRef.set(new TreeMap());
        try {
            Files.walkFileTree(workspaceRoot, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if ("src".equals(dir.getFileName().toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (n4jsLibraryNames.contains(dir.toFile().getName())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fName = file.getFileName().toString();
                    if ((fName.endsWith(".js") || fName.endsWith(".jsx")) && GeneratedJSFilesCounter.pathContainsSrcGen(file)) {
                        Path directory;
                        TreeMap fileMap = (TreeMap)genFilesRef.get();
                        if (!fileMap.containsKey(directory = file.getParent())) {
                            fileMap.put(directory, new HashSet());
                        }
                        Path relativeFile = workspaceRoot.relativize(file);
                        ((HashSet)fileMap.get(directory)).add(relativeFile.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if ("src-gen".equals(dir.getFileName().toString())) {
                        return FileVisitResult.SKIP_SIBLINGS;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (TreeMap)genFilesRef.get();
    }

    private static boolean pathContainsSrcGen(Path path) {
        if (path == null || path.getNameCount() == 0) {
            return false;
        }
        Path pathName = path.getName(path.getNameCount() - 1);
        if ("src-gen".equals(pathName.toString())) {
            return true;
        }
        return GeneratedJSFilesCounter.pathContainsSrcGen(path.getParent());
    }

    private static File findN4jsLibRoot() {
        File base = new File(new File("").getAbsolutePath());
        File n4jsLibrariesRoot = new File(base, "n4js-libs/packages");
        while (base.getParentFile() != null && !n4jsLibrariesRoot.isDirectory()) {
            base = base.getParentFile();
            n4jsLibrariesRoot = new File(base, "n4js-libs/packages");
        }
        return n4jsLibrariesRoot;
    }
}

