/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import com.google.common.base.CharMatcher;
import java.util.Iterator;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

public class JSXIdentifierValueConverter
extends AbstractValueConverter<String> {
    private static final CharMatcher disallowedChar = CharMatcher.anyOf((CharSequence)" /\\").precomputed();

    public String toValue(String string, INode node) throws ValueConverterException {
        if (node != null) {
            Iterator leafNodes = node.getLeafNodes().iterator();
            while (leafNodes.hasNext()) {
                ILeafNode leading = (ILeafNode)leafNodes.next();
                if (leading.isHidden()) continue;
                ILeafNode first = leading;
                int firstOffset = first.getOffset();
                this.validate(string, firstOffset, first);
                while (leafNodes.hasNext()) {
                    ILeafNode toBeChecked = (ILeafNode)leafNodes.next();
                    this.validate(string, firstOffset, toBeChecked);
                }
            }
        } else {
            int idx = disallowedChar.indexIn((CharSequence)string);
            if (idx != -1) {
                throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_IDENT_ILLEGAL_CHAR_WITH_RESULT(string, Character.valueOf(string.charAt(idx)), idx), "VCO_IDENT_ILLEGAL_CHAR_WITH_RESULT", node, string.substring(0, idx), null);
            }
        }
        return string;
    }

    private void validate(String value, int firstOffset, ILeafNode leaf) {
        if (leaf.isHidden()) {
            int idx = leaf.getTotalOffset() - firstOffset;
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_JSXIDENT_WHITESPACE_COMMENT(), "VCO_JSXIDENT_WHITESPACE_COMMENT", (INode)leaf, value.substring(0, idx), null);
        }
        int escapeSequence = leaf.getText().indexOf("\\");
        if (escapeSequence >= 0) {
            int idx = leaf.getTotalOffset() - firstOffset + escapeSequence;
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_IDENT_ILLEGAL_CHAR_WITH_RESULT(value, Character.valueOf(leaf.getText().charAt(escapeSequence)), idx), "VCO_IDENT_ILLEGAL_CHAR_WITH_RESULT", (INode)leaf, value.substring(0, idx), null);
        }
    }

    public String toString(String value) throws ValueConverterException {
        return value;
    }
}

