/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.transpiler.es.EcmaScriptSubGenerator;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;
import org.eclipse.xtext.resource.impl.ProjectDescription;

public class N4JSOutputConfigurationProvider
extends OutputConfigurationProvider {
    @Inject
    private IN4JSCore n4jsCore;

    public Set<OutputConfiguration> getOutputConfigurations() {
        HashSet<OutputConfiguration> outputConfs = new HashSet<OutputConfiguration>();
        for (IN4JSProject prj : this.n4jsCore.findAllProjects()) {
            OutputConfiguration outputConfiguration = this.getOutputConfiguration(prj);
            outputConfs.add(outputConfiguration);
        }
        return outputConfs;
    }

    public Set<OutputConfiguration> getOutputConfigurations(ResourceSet context) {
        EList resources = context.getResources();
        if (resources.isEmpty()) {
            ProjectDescription description = ProjectDescription.findInEmfObject((Notifier)context);
            IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(new N4JSProjectName(description.getName())).orNull();
            return this.getOutputConfigurationSet(project);
        }
        return this.getOutputConfigurations((Resource)resources.get(0));
    }

    public Set<OutputConfiguration> getOutputConfigurations(Resource context) {
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(context.getURI()).orNull();
        return this.getOutputConfigurationSet(project);
    }

    private Set<OutputConfiguration> getOutputConfigurationSet(IN4JSProject project) {
        HashSet<OutputConfiguration> outputConfs = new HashSet<OutputConfiguration>();
        outputConfs.add(this.getOutputConfiguration(project));
        return outputConfs;
    }

    private OutputConfiguration getOutputConfiguration(IN4JSProject project) {
        String outputPath = null;
        if (project != null) {
            outputPath = project.getOutputPath();
        }
        OutputConfiguration defaultOutputConfig = EcmaScriptSubGenerator.createDefaultOutputConfiguration();
        if (outputPath != null) {
            defaultOutputConfig.setOutputDirectory(outputPath);
        }
        return defaultOutputConfig;
    }
}

