/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.n4js.ide.xtext.server.DocumentResourceProvider;
import org.eclipse.n4js.ide.xtext.server.IssueAcceptor;
import org.eclipse.n4js.ide.xtext.server.XBuildManager;
import org.eclipse.n4js.ide.xtext.server.XIProjectDescriptionFactory;
import org.eclipse.n4js.ide.xtext.server.XIWorkspaceConfigFactory;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

@Singleton
public class XWorkspaceManager
implements DocumentResourceProvider {
    private static final Logger LOG = Logger.getLogger(XWorkspaceManager.class);
    @Inject
    private Provider<XProjectManager> projectManagerProvider;
    @Inject
    private XIWorkspaceConfigFactory workspaceConfigFactory;
    @Inject
    private XIProjectDescriptionFactory projectDescriptionFactory;
    @Inject
    private IssueAcceptor issueAcceptor;
    private XBuildManager buildManager;
    private final Map<String, XProjectManager> projectName2ProjectManager = new HashMap<String, XProjectManager>();
    private URI baseDir;
    private IWorkspaceConfig workspaceConfig;
    private final List<ILanguageServerAccess.IBuildListener> buildListeners = new ArrayList<ILanguageServerAccess.IBuildListener>();
    private final Map<String, ResourceDescriptionsData> fullIndex = Collections.synchronizedMap(new HashMap());
    private final Map<URI, Document> openDocuments = new HashMap<URI, Document>();
    private final IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider = new IExternalContentSupport.IExternalContentProvider(){

        public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
            return this;
        }

        public String getContent(URI uri) {
            Document document = XWorkspaceManager.this.openDocuments.get(uri);
            if (document != null) {
                return document.getContents();
            }
            return null;
        }

        public boolean hasContent(URI uri) {
            return XWorkspaceManager.this.isDocumentOpen(uri);
        }
    };

    public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.add(listener);
    }

    public void removeBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.remove(listener);
    }

    @Inject
    public void setBuildManager(XBuildManager buildManager) {
        buildManager.setWorkspaceManager(this);
        this.buildManager = buildManager;
    }

    public XBuildManager getBuildManager() {
        return this.buildManager;
    }

    public boolean isOpenedFile(URI uri) {
        return this.openDocuments.containsKey(uri);
    }

    public void initialize(URI baseDir) {
        this.baseDir = baseDir;
        this.setWorkspaceConfig(this.workspaceConfigFactory.getWorkspaceConfig(baseDir));
    }

    public void refreshWorkspaceConfig() {
        this.setWorkspaceConfig(this.workspaceConfigFactory.getWorkspaceConfig(this.baseDir));
        Set<String> projectNames = this.projectName2ProjectManager.keySet();
        HashSet<String> remainingProjectNames = new HashSet<String>(projectNames);
        for (IProjectConfig projectConfig : this.getWorkspaceConfig().getProjects()) {
            if (this.projectName2ProjectManager.containsKey(projectConfig.getName())) {
                remainingProjectNames.remove(projectConfig.getName());
                continue;
            }
            XProjectManager projectManager = (XProjectManager)this.projectManagerProvider.get();
            ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription(projectConfig);
            projectManager.initialize(projectDescription, projectConfig, this.openedDocumentsContentProvider, (Provider<Map<String, ResourceDescriptionsData>>)((Provider)() -> this.fullIndex));
            this.projectName2ProjectManager.put(projectDescription.getName(), projectManager);
        }
        for (String deletedProject : remainingProjectNames) {
            this.projectName2ProjectManager.remove(deletedProject);
            this.fullIndex.remove(deletedProject);
        }
    }

    public void clean(CancelIndicator cancelIndicator) {
        this.buildManager.doClean(cancelIndicator);
    }

    public void persistProjectState(CancelIndicator indicator) {
        this.buildManager.persistProjectState(indicator);
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    public IWorkspaceConfig getWorkspaceConfig() throws ResponseErrorException {
        if (this.workspaceConfig == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.serverNotInitialized, "Workspace has not been initialized yet.", null);
            throw new ResponseErrorException(error);
        }
        return this.workspaceConfig;
    }

    protected void setWorkspaceConfig(IWorkspaceConfig workspaceConfig) {
        this.workspaceConfig = workspaceConfig;
    }

    protected void afterBuild(List<IResourceDescription.Delta> deltas) {
        for (ILanguageServerAccess.IBuildListener listener : this.buildListeners) {
            listener.afterBuild(deltas);
        }
    }

    public XBuildManager.XBuildable didChangeFiles(List<URI> dirtyFiles, List<URI> deletedFiles) {
        XBuildManager.XBuildable buildable = this.buildManager.doIncrementalBuild(dirtyFiles, deletedFiles);
        return cancelIndicator -> {
            List<IResourceDescription.Delta> deltas = buildable.build(cancelIndicator);
            this.afterBuild(deltas);
            return deltas;
        };
    }

    public void clearIssues(URI uri) {
        this.issueAcceptor.publishDiagnostics(uri, Collections.emptyList());
    }

    public void doInitialBuild(CancelIndicator cancelIndicator) {
        ArrayList<ProjectDescription> newProjects = new ArrayList<ProjectDescription>();
        for (IProjectConfig projectConfig : this.getWorkspaceConfig().getProjects()) {
            ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription(projectConfig);
            newProjects.add(projectDescription);
        }
        List<IResourceDescription.Delta> deltas = this.buildManager.doInitialBuild(newProjects, cancelIndicator);
        this.afterBuild(deltas);
    }

    public List<IResourceDescription.Delta> doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        return this.didChangeFiles(dirtyFiles, deletedFiles).build(cancelIndicator);
    }

    public IResourceDescriptions getIndex() {
        return new ChunkedResourceDescriptions(this.fullIndex);
    }

    public URI getProjectBaseDir(URI uri) {
        IProjectConfig projectConfig = this.getProjectConfig(uri);
        if (projectConfig != null) {
            return projectConfig.getPath();
        }
        return null;
    }

    public XProjectManager getProjectManager(URI uri) {
        IProjectConfig projectConfig = this.getProjectConfig(uri);
        String name = null;
        if (projectConfig != null) {
            name = projectConfig.getName();
        }
        return this.getProjectManager(name);
    }

    public IProjectConfig getProjectConfig(URI uri) {
        return this.getWorkspaceConfig().findProjectContaining(uri);
    }

    public XProjectManager getProjectManager(String projectName) {
        return this.projectName2ProjectManager.get(projectName);
    }

    public Collection<XProjectManager> getProjectManagers() {
        return Collections.unmodifiableCollection(this.projectName2ProjectManager.values());
    }

    @Deprecated
    public List<IResourceDescription.Delta> didChange(URI uri, Integer version, Iterable<TextEdit> changes, CancelIndicator cancelIndicator) {
        return this.didChange(uri, version, changes).build(cancelIndicator);
    }

    @Deprecated
    public XBuildManager.XBuildable didChange(URI uri, Integer version, Iterable<TextEdit> changes) {
        Document contents = this.openDocuments.get(uri);
        if (contents == null) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return XBuildManager.XBuildable.NO_BUILD;
        }
        this.openDocuments.put(uri, contents.applyChanges(changes));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), Collections.emptyList());
    }

    public XBuildManager.XBuildable didChangeTextDocumentContent(URI uri, Integer version, Iterable<TextDocumentContentChangeEvent> changes) {
        Document contents = this.openDocuments.get(uri);
        if (contents == null) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return XBuildManager.XBuildable.NO_BUILD;
        }
        this.openDocuments.put(uri, contents.applyTextDocumentChanges(changes));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), Collections.emptyList());
    }

    public List<IResourceDescription.Delta> didOpen(URI uri, Integer version, String contents, CancelIndicator cancelIndicator) {
        return this.didOpen(uri, version, contents).build(cancelIndicator);
    }

    public XBuildManager.XBuildable didOpen(URI uri, Integer version, String contents) {
        this.openDocuments.put(uri, new Document(version, contents));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), Collections.emptyList());
    }

    @Deprecated
    public List<IResourceDescription.Delta> didClose(URI uri, CancelIndicator cancelIndicator) {
        return this.didClose(uri).build(cancelIndicator);
    }

    public XBuildManager.XBuildable didClose(URI uri) {
        this.openDocuments.remove(uri);
        if (this.exists(uri)) {
            return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), Collections.emptyList());
        }
        return this.didChangeFiles(Collections.emptyList(), (List<URI>)ImmutableList.of((Object)uri));
    }

    protected boolean exists(URI uri) {
        XtextResourceSet rs;
        XProjectManager projectManager = this.getProjectManager(uri);
        if (projectManager != null && (rs = projectManager.getResourceSet()) != null) {
            return rs.getURIConverter().exists(uri, null);
        }
        return false;
    }

    @Override
    public XtextResource getResource(URI uri) {
        URI resourceURI = uri.trimFragment();
        XProjectManager projectMnr = this.getProjectManager(resourceURI);
        if (projectMnr != null) {
            XtextResource resource = (XtextResource)projectMnr.getResource(resourceURI);
            return resource;
        }
        return null;
    }

    @Override
    public Document getDocument(URI uri) {
        XtextResource resource = this.getResource(uri);
        if (resource == null) {
            return null;
        }
        Document doc = this.openDocuments.get(resource.getURI());
        if (doc != null) {
            return doc;
        }
        String text = resource.getParseResult().getRootNode().getText();
        return new Document(Integer.valueOf(1), text);
    }

    @Override
    public Document getDocument(XtextResource resource) {
        if (resource == null) {
            return null;
        }
        Document doc = this.openDocuments.get(resource.getURI());
        if (doc != null) {
            return doc;
        }
        String text = resource.getParseResult().getRootNode().getText();
        return new Document(Integer.valueOf(1), text);
    }

    public boolean isDocumentOpen(URI uri) {
        return this.openDocuments.containsKey(uri);
    }

    public URI makeWorkspaceRelative(URI uri) {
        FileURI fileUri = new FileURI(uri);
        URI relativeUri = fileUri.toURI().deresolve(this.getBaseDir());
        return relativeUri;
    }
}

