/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.organize.imports;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.organize.imports.ImportProvidedElement;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ImportSpecifiersUtil {
    public static List<ImportProvidedElement> mapToImportProvidedElements(List<ImportSpecifier> importSpecifiers) {
        Functions.Function1 _function = specifier -> {
            boolean _matched = false;
            if (specifier instanceof NamespaceImportSpecifier) {
                _matched = true;
                return ImportSpecifiersUtil.namespaceToProvidedElements((NamespaceImportSpecifier)specifier);
            }
            if (!_matched && specifier instanceof NamedImportSpecifier) {
                _matched = true;
                String _usedName = ImportSpecifiersUtil.usedName((NamedImportSpecifier)specifier);
                String _importedElementName = ImportSpecifiersUtil.importedElementName((NamedImportSpecifier)specifier);
                ImportProvidedElement _importProvidedElement = new ImportProvidedElement(_usedName, _importedElementName, (ImportSpecifier)specifier);
                return CollectionLiterals.newArrayList((Object[])new ImportProvidedElement[]{_importProvidedElement});
            }
            return CollectionLiterals.emptyList();
        };
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map(importSpecifiers, (Functions.Function1)_function)));
    }

    private static List<ImportProvidedElement> namespaceToProvidedElements(NamespaceImportSpecifier specifier) {
        boolean _tripleEquals;
        TModule _importedModule = ImportSpecifiersUtil.importedModule((ImportSpecifier)specifier);
        boolean bl = _tripleEquals = _importedModule == null;
        if (_tripleEquals) {
            return CollectionLiterals.emptyList();
        }
        ArrayList importProvidedElements = CollectionLiterals.newArrayList();
        String _alias = specifier.getAlias();
        String _computeNamespaceActualName = ImportSpecifiersUtil.computeNamespaceActualName(specifier);
        ImportProvidedElement _importProvidedElement = new ImportProvidedElement(_alias, _computeNamespaceActualName, (ImportSpecifier)specifier);
        importProvidedElements.add(_importProvidedElement);
        Functions.Function1 _function = it -> it.isExported();
        Functions.Function1 _function_1 = it -> it;
        Iterable topExportedTypes = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ImportSpecifiersUtil.importedModule((ImportSpecifier)specifier).getTopLevelTypes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.isExported();
        Functions.Function1 _function_3 = it -> it;
        Iterable topExportedVars = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ImportSpecifiersUtil.importedModule((ImportSpecifier)specifier).getVariables(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        Iterable topExported = Iterables.concat((Iterable)topExportedTypes, (Iterable)topExportedVars);
        Consumer<TExportableElement> _function_4 = type -> {
            String _importedElementName = ImportSpecifiersUtil.importedElementName(specifier, type);
            String _exportedName = type.getExportedName();
            ImportProvidedElement _importProvidedElement_1 = new ImportProvidedElement(_importedElementName, _exportedName, (ImportSpecifier)specifier);
            importProvidedElements.add(_importProvidedElement_1);
        };
        topExported.forEach(_function_4);
        return importProvidedElements;
    }

    public static String computeNamespaceActualName(NamespaceImportSpecifier specifier) {
        String _xifexpression = null;
        boolean _eIsProxy = ImportSpecifiersUtil.importedModule((ImportSpecifier)specifier).eIsProxy();
        if (_eIsProxy) {
            int _hashCode = specifier.hashCode();
            _xifexpression = "NAMESPACE_" + Integer.valueOf(_hashCode);
        } else {
            String _string = ImportSpecifiersUtil.importedModule((ImportSpecifier)specifier).getQualifiedName().toString();
            _xifexpression = "NAMESPACE_" + _string;
        }
        return _xifexpression;
    }

    public static String importedElementName(NamedImportSpecifier specifier) {
        TExportableElement element = specifier.getImportedElement();
        if (element == null) {
            String _importedElementAsText = specifier.getImportedElementAsText();
            String _plus = "<" + _importedElementAsText;
            return String.valueOf(_plus) + ">(null)";
        }
        boolean _eIsProxy = element.eIsProxy();
        if (_eIsProxy) {
            String _importedElementAsText_1 = specifier.getImportedElementAsText();
            String _plus_1 = "<" + _importedElementAsText_1;
            return String.valueOf(_plus_1) + ">(proxy)";
        }
        return element.getExportedName();
    }

    public static String usedName(NamedImportSpecifier it) {
        String _xifexpression = null;
        String _alias = it.getAlias();
        boolean _tripleEquals = _alias == null;
        _xifexpression = _tripleEquals ? ImportSpecifiersUtil.importedElementName(it) : it.getAlias();
        return _xifexpression;
    }

    public static String importedElementName(NamespaceImportSpecifier is, TExportableElement element) {
        String _alias = is.getAlias();
        String _plus = String.valueOf(_alias) + ".";
        String _exportedName = element.getExportedName();
        return String.valueOf(_plus) + _exportedName;
    }

    public static TModule importedModule(ImportSpecifier it) {
        EObject _eContainer = it.eContainer();
        return ((ImportDeclaration)_eContainer).getModule();
    }

    public static boolean isBrokenImport(ImportSpecifier spec) {
        TModule module = ImportSpecifiersUtil.importedModule(spec);
        if (module == null || module.eIsProxy() || StringExtensions.isNullOrEmpty((String)module.getQualifiedName())) {
            return true;
        }
        if (spec instanceof NamedImportSpecifier) {
            boolean _not;
            NamedImportSpecifier nis = (NamedImportSpecifier)spec;
            if (nis == null || nis.eIsProxy() || StringExtensions.isNullOrEmpty((String)nis.getImportedElementAsText())) {
                return true;
            }
            TExportableElement imported = nis.getImportedElement();
            if (imported == null) {
                return true;
            }
            boolean _eIsProxy = imported.eIsProxy();
            boolean bl = _not = !_eIsProxy;
            if (_not) {
                return StringExtensions.isNullOrEmpty((String)imported.getExportedName());
            }
        }
        return false;
    }
}

