/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.generator;

import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.generator.IGeneratorMarkerSupport;

@Singleton
public class GeneratorMarkerSupport
implements IGeneratorMarkerSupport {
    private static final Logger LOGGER = Logger.getLogger(GeneratorMarkerSupport.class);
    private final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public void createMarker(Resource res, String message, IGeneratorMarkerSupport.Severity severity) {
        int severityEclipse;
        switch (severity) {
            case INFO: {
                severityEclipse = 0;
                break;
            }
            case WARNING: {
                severityEclipse = 1;
                break;
            }
            default: {
                severityEclipse = 2;
            }
        }
        try {
            IMarker marker = this.toIFile(res).createMarker("org.eclipse.n4js.ui.compiler.error");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severityEclipse);
            marker.setAttribute("lineNumber", 1);
        }
        catch (CoreException e) {
            LOGGER.error((Object)e.getStatus());
            String resInfo = "";
            if (res != null) {
                resInfo = res.getURI() != null ? "on resource with uri=" + res.getURI() : "on resource=" + res;
            }
            throw new RuntimeException("Cannot create error marker with message='" + message + "' " + resInfo + ".", e);
        }
    }

    public void deleteMarker(Resource res) {
        try {
            this.toIFile(res).deleteMarkers("org.eclipse.n4js.ui.compiler.error", true, 0);
        }
        catch (CoreException e) {
            LOGGER.error((Object)e.getStatus());
        }
    }

    public boolean hasMarker(Resource res) {
        try {
            return this.toIFile(res).findMarkers("org.eclipse.n4js.ui.compiler.error", true, 0).length > 0;
        }
        catch (CoreException e) {
            LOGGER.error((Object)e.getStatus());
            return false;
        }
    }

    private IFile toIFile(Resource res) {
        return this.toIFile(res.getURI());
    }

    private IFile toIFile(URI uri) {
        return this.workspaceRoot.getFile((IPath)new Path(uri.toPlatformString(true)));
    }
}

