/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.n4js.utils.resources.DelegatingWorkspace;
import org.eclipse.n4js.utils.resources.IExternalResource;

public class ExternalFile
extends org.eclipse.core.internal.resources.File
implements IExternalResource {
    private final File file;
    private final URI uri;
    private final IProject project;
    private final IContainer parent;

    public ExternalFile(IProject project, IContainer parent, File file) {
        super((IPath)new Path(file.getAbsolutePath()), null);
        this.file = file;
        this.uri = file.toURI();
        this.project = project;
        this.parent = parent;
    }

    @Override
    public File getExternalResource() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public IProject getProject() {
        return this.project;
    }

    public IContainer getParent() {
        return this.parent;
    }

    public boolean exists() {
        return this.file.exists() && this.file.isFile();
    }

    public boolean exists(int flags, boolean checkType) {
        return this.exists();
    }

    public boolean isAccessible() {
        return this.exists();
    }

    public boolean isReadOnly() {
        return !this.file.canWrite();
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        visitor.visit((IResource)this);
    }

    public URI getLocationURI() {
        return this.uri;
    }

    public IPath getLocation() {
        return new Path(this.file.toPath().toString());
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.file.delete();
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.delete(force, monitor);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.delete(true, monitor);
    }

    public void deleteResource(boolean convertToPhantom, MultiStatus status) throws CoreException {
        this.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public IMarker findMarker(long id) {
        return null;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        return new IMarker[0];
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
    }

    public IWorkspace getWorkspace() {
        return new DelegatingWorkspace();
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        if (this.exists()) {
            this.file.setLastModified(System.currentTimeMillis());
        }
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File '" + this.file + "' does not exist.", e);
        }
    }

    public IPath getFullPath() {
        return new Path(this.file.getAbsolutePath());
    }

    public String toString() {
        return "E" + super.toString();
    }
}

