/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.lsp.N4JSProjectConfig;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.lsp.IN4JSSourceFolder;
import org.eclipse.xtext.util.IFileSystemScanner;

public class N4JSSourceFolder
implements IN4JSSourceFolder {
    private final IN4JSSourceContainer delegate;
    private final N4JSProjectConfig project;

    public N4JSSourceFolder(N4JSProjectConfig project, IN4JSSourceContainer delegate) {
        this.project = project;
        this.delegate = delegate;
    }

    @Override
    public N4JSProjectConfig getProject() {
        return this.project;
    }

    public String getName() {
        return this.delegate.getRelativeLocation();
    }

    public URI getPath() {
        return ((SafeURI)this.delegate.getLocation().withTrailingPathDelimiter()).toURI();
    }

    public List<URI> getAllResources(IFileSystemScanner scanner) {
        ArrayList<URI> uris = new ArrayList<URI>();
        URI projectBase = this.getPath();
        scanner.scan(projectBase, uri -> {
            URI relativeUri = uri.deresolve(projectBase);
            if (relativeUri.segmentCount() > 0 && !relativeUri.segment(0).equals("node_modules")) {
                uris.add((URI)uri);
            }
        });
        return uris;
    }
}

