/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayBindingPattern;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionAnnotationList;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.JSXAbstractElement;
import org.eclipse.n4js.n4JS.JSXAttribute;
import org.eclipse.n4js.n4JS.JSXChild;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXExpression;
import org.eclipse.n4js.n4JS.JSXFragment;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.JSXSpreadAttribute;
import org.eclipse.n4js.n4JS.Literal;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NewTarget;
import org.eclipse.n4js.n4JS.ObjectBindingPattern;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertyNameValuePairSingleName;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.TaggedTemplateString;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.n4JS.util.N4JSSwitch;

final class CFEChildren {
    CFEChildren() {
    }

    static List<Node> get(ReentrantASTIterator astIter, ControlFlowElement expr) {
        return (List)new InternalExpressionChildren(astIter).doSwitch((EObject)expr);
    }

    static Node addDelegatingNode(ReentrantASTIterator astIter, List<Node> cfc, String name, ControlFlowElement cfe, ControlFlowElement delegate) {
        if (delegate != null) {
            DelegatingNode delegatingNode = DelegatingNodeFactory.create(astIter, name, cfe, delegate);
            cfc.add(delegatingNode);
            return delegatingNode;
        }
        return null;
    }

    private static class InternalExpressionChildren
    extends N4JSSwitch<List<Node>> {
        private final ReentrantASTIterator astIter;

        InternalExpressionChildren(ReentrantASTIterator astIter) {
            this.astIter = astIter;
        }

        Node addDelegatingNode(List<Node> cfc, String name, ControlFlowElement cfe, ControlFlowElement delegate) {
            return CFEChildren.addDelegatingNode(this.astIter, cfc, name, cfe, delegate);
        }

        Node addHelperNode(List<Node> cfc, String name, ControlFlowElement cfe) {
            HelperNode node = new HelperNode(name, this.astIter.pos(), cfe);
            cfc.add(node);
            return node;
        }

        public List<Node> caseAdditiveExpression(AdditiveExpression ae) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "arg_1", (ControlFlowElement)ae, (ControlFlowElement)ae.getLhs());
            this.addDelegatingNode(cfc, "arg_2", (ControlFlowElement)ae, (ControlFlowElement)ae.getRhs());
            return cfc;
        }

        public List<Node> caseAssignmentExpression(AssignmentExpression ae) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            Expression lhs = ae.getLhs();
            this.addDelegatingNode(cfc, "lhs", (ControlFlowElement)ae, (ControlFlowElement)lhs);
            this.addDelegatingNode(cfc, "rhs", (ControlFlowElement)ae, (ControlFlowElement)ae.getRhs());
            return cfc;
        }

        public List<Node> caseArrayLiteral(ArrayLiteral al) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            for (ArrayElement aElem : al.getElements()) {
                int i = al.getElements().indexOf((Object)aElem);
                String name = "arrayElem_" + i;
                Expression exp = aElem.getExpression();
                if (exp == null) {
                    this.addHelperNode(cfc, name, (ControlFlowElement)al);
                    continue;
                }
                this.addDelegatingNode(cfc, name, (ControlFlowElement)al, (ControlFlowElement)exp);
            }
            return cfc;
        }

        public List<Node> caseAwaitExpression(AwaitExpression ae) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)ae, (ControlFlowElement)ae.getExpression());
            return cfc;
        }

        public List<Node> caseBinaryBitwiseExpression(BinaryBitwiseExpression bbe) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "arg_1", (ControlFlowElement)bbe, (ControlFlowElement)bbe.getLhs());
            this.addDelegatingNode(cfc, "arg_2", (ControlFlowElement)bbe, (ControlFlowElement)bbe.getRhs());
            return cfc;
        }

        public List<Node> caseBindingElement(BindingElement be) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "nestedPattern", (ControlFlowElement)be, (ControlFlowElement)be.getNestedPattern());
            this.addDelegatingNode(cfc, "declaration", (ControlFlowElement)be, (ControlFlowElement)be.getVarDecl());
            this.addDelegatingNode(cfc, "initializer", (ControlFlowElement)be, (ControlFlowElement)be.getExpression());
            return cfc;
        }

        public List<Node> caseArrayBindingPattern(ArrayBindingPattern abp) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            int i = 0;
            while (i < abp.getElements().size()) {
                BindingElement be = (BindingElement)abp.getElements().get(i);
                this.addDelegatingNode(cfc, "elem_" + i, (ControlFlowElement)abp, (ControlFlowElement)be);
                ++i;
            }
            return cfc;
        }

        public List<Node> caseObjectBindingPattern(ObjectBindingPattern obp) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            int i = 0;
            while (i < obp.getProperties().size()) {
                BindingProperty bp = (BindingProperty)obp.getProperties().get(i);
                BindingElement be = bp.getValue();
                this.addDelegatingNode(cfc, "init_" + i, (ControlFlowElement)obp, (ControlFlowElement)be);
                ++i;
            }
            return cfc;
        }

        public List<Node> caseCastExpression(CastExpression ce) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)ce, (ControlFlowElement)ce.getExpression());
            return cfc;
        }

        public List<Node> caseCommaExpression(CommaExpression ce) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            int i = 0;
            while (i < ce.getExprs().size()) {
                Expression expr = (Expression)ce.getExprs().get(i);
                this.addDelegatingNode(cfc, "expression_" + i, (ControlFlowElement)ce, (ControlFlowElement)expr);
                ++i;
            }
            return cfc;
        }

        public List<Node> caseEqualityExpression(EqualityExpression ee) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "arg_1", (ControlFlowElement)ee, (ControlFlowElement)ee.getLhs());
            this.addDelegatingNode(cfc, "arg_2", (ControlFlowElement)ee, (ControlFlowElement)ee.getRhs());
            return cfc;
        }

        public List<Node> caseExpressionAnnotationList(ExpressionAnnotationList eal) {
            return Collections.emptyList();
        }

        public List<Node> caseFunctionExpression(FunctionExpression fe) {
            return Collections.emptyList();
        }

        public List<Node> caseIdentifierRef(IdentifierRef al) {
            return Collections.emptyList();
        }

        public List<Node> caseIndexedAccessExpression(IndexedAccessExpression iae) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "index", (ControlFlowElement)iae, (ControlFlowElement)iae.getIndex());
            return cfc;
        }

        public List<Node> caseLiteral(Literal lit) {
            return Collections.emptyList();
        }

        public List<Node> caseMultiplicativeExpression(MultiplicativeExpression me) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "arg_1", (ControlFlowElement)me, (ControlFlowElement)me.getLhs());
            this.addDelegatingNode(cfc, "arg_2", (ControlFlowElement)me, (ControlFlowElement)me.getRhs());
            return cfc;
        }

        public List<Node> caseN4ClassExpression(N4ClassExpression n4ce) {
            return Collections.emptyList();
        }

        public List<Node> caseNewExpression(NewExpression ne) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "callee", (ControlFlowElement)ne, (ControlFlowElement)ne.getCallee());
            int i = 0;
            while (i < ne.getArguments().size()) {
                Argument arg = (Argument)ne.getArguments().get(i);
                this.addDelegatingNode(cfc, "arg_" + i, (ControlFlowElement)ne, (ControlFlowElement)arg.getExpression());
                ++i;
            }
            return cfc;
        }

        public List<Node> caseNewTarget(NewTarget nt) {
            return Collections.emptyList();
        }

        public List<Node> caseObjectLiteral(ObjectLiteral ol) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            int i = 0;
            while (i < ol.getPropertyAssignments().size()) {
                PropertyAssignment pa = (PropertyAssignment)ol.getPropertyAssignments().get(i);
                if (pa instanceof PropertyNameValuePair) {
                    PropertyNameValuePair pnvp = (PropertyNameValuePair)pa;
                    LiteralOrComputedPropertyName locpn = pnvp.getDeclaredName();
                    if (locpn != null) {
                        this.addDelegatingNode(cfc, "declaredName_" + i, (ControlFlowElement)ol, (ControlFlowElement)locpn.getExpression());
                    }
                    this.addDelegatingNode(cfc, "expression_" + i, (ControlFlowElement)ol, (ControlFlowElement)pnvp.getExpression());
                    if (pa instanceof PropertyNameValuePairSingleName) {
                        PropertyNameValuePairSingleName pnvpsv = (PropertyNameValuePairSingleName)pa;
                        this.addDelegatingNode(cfc, "identifierRef_" + i, (ControlFlowElement)ol, (ControlFlowElement)pnvpsv.getIdentifierRef());
                    }
                }
                ++i;
            }
            return cfc;
        }

        public List<Node> caseParenExpression(ParenExpression pe) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)pe, (ControlFlowElement)pe.getExpression());
            return cfc;
        }

        public List<Node> caseParameterizedCallExpression(ParameterizedCallExpression pce) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            int i = 0;
            while (i < pce.getArguments().size()) {
                Argument arg = (Argument)pce.getArguments().get(i);
                this.addDelegatingNode(cfc, "arg_" + i, (ControlFlowElement)pce, (ControlFlowElement)arg.getExpression());
                ++i;
            }
            return cfc;
        }

        public List<Node> caseImportCallExpression(ImportCallExpression ice) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            Argument arg = ice.getArgument();
            if (arg != null) {
                this.addDelegatingNode(cfc, "arg_0", (ControlFlowElement)ice, (ControlFlowElement)arg.getExpression());
            }
            return cfc;
        }

        public List<Node> caseParameterizedPropertyAccessExpression(ParameterizedPropertyAccessExpression ppae) {
            return Collections.emptyList();
        }

        public List<Node> casePostfixExpression(PostfixExpression pe) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)pe, (ControlFlowElement)pe.getExpression());
            return cfc;
        }

        public List<Node> casePromisifyExpression(PromisifyExpression pe) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)pe, (ControlFlowElement)pe.getExpression());
            return cfc;
        }

        public List<Node> caseRelationalExpression(RelationalExpression re) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "arg_1", (ControlFlowElement)re, (ControlFlowElement)re.getLhs());
            this.addDelegatingNode(cfc, "arg_2", (ControlFlowElement)re, (ControlFlowElement)re.getRhs());
            return cfc;
        }

        public List<Node> caseShiftExpression(ShiftExpression se) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "arg_1", (ControlFlowElement)se, (ControlFlowElement)se.getLhs());
            this.addDelegatingNode(cfc, "arg_2", (ControlFlowElement)se, (ControlFlowElement)se.getRhs());
            return cfc;
        }

        public List<Node> caseSuperLiteral(SuperLiteral sl) {
            return Collections.emptyList();
        }

        public List<Node> caseTaggedTemplateString(TaggedTemplateString tts) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "template", (ControlFlowElement)tts, (ControlFlowElement)tts.getTemplate());
            return cfc;
        }

        public List<Node> caseTemplateLiteral(TemplateLiteral tl) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            int i = 0;
            while (i < tl.getSegments().size()) {
                Expression segm = (Expression)tl.getSegments().get(i);
                this.addDelegatingNode(cfc, "segment_" + i, (ControlFlowElement)tl, (ControlFlowElement)segm);
                ++i;
            }
            return cfc;
        }

        public List<Node> caseThisLiteral(ThisLiteral tl) {
            return Collections.emptyList();
        }

        public List<Node> caseUnaryExpression(UnaryExpression ue) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)ue, (ControlFlowElement)ue.getExpression());
            return cfc;
        }

        public List<Node> caseVariableBinding(VariableBinding vb) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)vb, (ControlFlowElement)vb.getExpression());
            this.addDelegatingNode(cfc, "pattern", (ControlFlowElement)vb, (ControlFlowElement)vb.getPattern());
            return cfc;
        }

        public List<Node> caseYieldExpression(YieldExpression ye) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)ye, (ControlFlowElement)ye.getExpression());
            return cfc;
        }

        public List<Node> caseJSXElement(JSXElement jsxel) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "openTagName", (ControlFlowElement)jsxel, (ControlFlowElement)jsxel.getJsxElementName().getExpression());
            int i = 0;
            while (i < jsxel.getJsxAttributes().size()) {
                JSXAttribute jsxAttr = (JSXAttribute)jsxel.getJsxAttributes().get(i);
                this.addDelegatingNode(cfc, "attr_" + i, (ControlFlowElement)jsxel, (ControlFlowElement)jsxAttr);
                ++i;
            }
            this.handleJSXAbstractElement(cfc, (JSXAbstractElement)jsxel);
            if (jsxel.getJsxClosingName() != null) {
                this.addDelegatingNode(cfc, "closeTagName", (ControlFlowElement)jsxel, (ControlFlowElement)jsxel.getJsxClosingName().getExpression());
            }
            return cfc;
        }

        public List<Node> caseJSXFragment(JSXFragment jsxFrag) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.handleJSXAbstractElement(cfc, (JSXAbstractElement)jsxFrag);
            return cfc;
        }

        private void handleJSXAbstractElement(List<Node> addHere, JSXAbstractElement jsxel) {
            int i = 0;
            while (i < jsxel.getJsxChildren().size()) {
                JSXChild jsxChild = (JSXChild)jsxel.getJsxChildren().get(i);
                if (jsxChild instanceof JSXElement) {
                    JSXElement jsxElem = (JSXElement)jsxChild;
                    this.addDelegatingNode(addHere, "child_" + i, (ControlFlowElement)jsxel, (ControlFlowElement)jsxElem);
                }
                if (jsxChild instanceof JSXExpression) {
                    JSXExpression jsxEx = (JSXExpression)jsxChild;
                    this.addDelegatingNode(addHere, "child_" + i, (ControlFlowElement)jsxel, (ControlFlowElement)jsxEx.getExpression());
                }
                ++i;
            }
        }

        public List<Node> caseJSXExpression(JSXExpression jsxEx) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            return cfc;
        }

        public List<Node> caseJSXSpreadAttribute(JSXSpreadAttribute jsxSA) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "expression", (ControlFlowElement)jsxSA, (ControlFlowElement)jsxSA.getExpression());
            return cfc;
        }

        public List<Node> caseJSXPropertyAttribute(JSXPropertyAttribute jsxPA) {
            LinkedList<Node> cfc = new LinkedList<Node>();
            this.addDelegatingNode(cfc, "value", (ControlFlowElement)jsxPA, (ControlFlowElement)jsxPA.getJsxAttributeValue());
            return cfc;
        }
    }
}

