/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.urischeme.internal.registration.IFileProvider;

public class FileProvider
implements IFileProvider {
    @Override
    public List<String> readAllLines(String path) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        return Files.readAllLines(filePath);
    }

    @Override
    public void write(String path, byte[] bytes) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        Files.write(filePath, bytes, new OpenOption[0]);
    }

    @Override
    public Reader newReader(String path) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        return Files.newBufferedReader(filePath);
    }

    @Override
    public Writer newWriter(String path) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        return Files.newBufferedWriter(filePath, new OpenOption[0]);
    }

    @Override
    public boolean fileExists(String path) {
        Path filePath = Paths.get(path, new String[0]);
        return Files.exists(filePath, new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(String path) {
        Path filePath = Paths.get(path, new String[0]);
        return Files.isDirectory(filePath, new LinkOption[0]);
    }

    @Override
    public String getFilePath(URL url) {
        return new File(url.getPath()).getPath();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(String path, String glob) throws IOException {
        Path dirPath = Paths.get(path, new String[0]);
        return Files.newDirectoryStream(dirPath, glob);
    }
}

