/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.classifiers;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.packagejson.model.edit.IJSONDocumentModification;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSClassifierWizardModel;
import org.eclipse.n4js.ui.wizard.generator.ContentBlock;
import org.eclipse.n4js.ui.wizard.generator.ImportAnalysis;
import org.eclipse.n4js.ui.wizard.generator.ImportRequirement;
import org.eclipse.n4js.ui.wizard.generator.N4JSImportRequirementResolver;
import org.eclipse.n4js.ui.wizard.generator.WizardGeneratorHelper;
import org.eclipse.n4js.ui.wizard.generator.WorkspaceWizardGenerator;
import org.eclipse.n4js.ui.wizard.generator.WorkspaceWizardGeneratorException;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public abstract class N4JSNewClassifierWizardGenerator<M extends N4JSClassifierWizardModel>
implements WorkspaceWizardGenerator<M> {
    private static final Logger LOGGER = Logger.getLogger(N4JSNewClassifierWizardGenerator.class);
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    @Extension
    private WizardGeneratorHelper generatorHelper;
    @Inject
    private N4JSImportRequirementResolver requirementResolver;

    @Override
    public ContentBlock[] generateContentPreview(M model) {
        boolean _not;
        IPath modulePath = ((N4JSClassifierWizardModel)model).computeFileLocation();
        boolean _exists = this.generatorHelper.exists(modulePath);
        if (_exists) {
            XtextResource resource = this.generatorHelper.getResource(URI.createPlatformResourceURI((String)modulePath.toString(), (boolean)true));
            List<ImportRequirement> requirements = this.getImportRequirements(model);
            ImportAnalysis importAnalysis = this.requirementResolver.analyzeImportRequirements(requirements, resource);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(modulePath);
            String _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = this.generatorHelper.readFileAsString(file);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    String _string = modulePath.toString();
                    String _plus = "Failed to create a content preview by overlaying existing module " + _string;
                    LOGGER.error((Object)_plus);
                    return (ContentBlock[])Conversions.unwrapArray((Object)CollectionLiterals.emptyList(), ContentBlock.class);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            String fileContent = _xtrycatchfinallyexpression;
            String importStatements = this.requirementResolver.generateImportStatements(importAnalysis.importRequirements);
            String classCode = this.generateClassifierCode(model, importAnalysis.aliasBindings);
            int importStatementOffset = this.requirementResolver.getImportStatementOffset(resource);
            String importStatementFileContent = fileContent.substring(0, importStatementOffset);
            String _xifexpression = null;
            int _length = fileContent.length();
            boolean _greaterThan = _length > 0;
            _xifexpression = _greaterThan ? this.generatorHelper.addLineBreak(fileContent.substring(importStatementOffset, fileContent.length())) : "";
            String bodyFileContent = _xifexpression;
            ContentBlock _unhighlighted = ContentBlock.unhighlighted(importStatementFileContent);
            ContentBlock _highlighted = ContentBlock.highlighted(this.generatorHelper.addLineBreak(importStatements));
            ContentBlock _unhighlighted_1 = ContentBlock.unhighlighted(bodyFileContent);
            ContentBlock _highlighted_1 = ContentBlock.highlighted(classCode);
            return new ContentBlock[]{_unhighlighted, _highlighted, _unhighlighted_1, _highlighted_1};
        }
        List<ImportRequirement> importRequirements = this.getImportRequirements(model);
        Map<URI, String> aliasBindings = this.requirementResolver.resolveImportNameConflicts(importRequirements, null);
        String importStatements_1 = this.requirementResolver.generateImportStatements(importRequirements);
        boolean _isEmpty = importStatements_1.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _importStatements = importStatements_1;
            importStatements_1 = String.valueOf(_importStatements) + "\n\n";
        }
        String _generateClassifierCode = this.generateClassifierCode(model, aliasBindings);
        String _plus = String.valueOf(importStatements_1) + _generateClassifierCode;
        ContentBlock _highlighted_2 = ContentBlock.highlighted(_plus);
        return new ContentBlock[]{_highlighted_2};
    }

    @Override
    public void writeToFile(M model, IProgressMonitor monitor) {
        IPath modulePath = ((N4JSClassifierWizardModel)model).computeFileLocation();
        IFile moduleFile = ResourcesPlugin.getWorkspace().getRoot().getFile(modulePath);
        try {
            boolean _exists = moduleFile.exists();
            if (_exists) {
                this.insertIntoFile(moduleFile, model);
            } else {
                boolean _not;
                List<ImportRequirement> importRequirements = this.getImportRequirements(model);
                Map<URI, String> aliasBindings = this.requirementResolver.resolveImportNameConflicts(importRequirements, null);
                String importStatements = this.requirementResolver.generateImportStatements(importRequirements);
                boolean _isEmpty = importRequirements.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    importStatements = String.valueOf(importStatements) + "\n" + "\n";
                }
                String classifierCode = this.generateClassifierCode(model, aliasBindings);
                StringInputStream classifierTextStream = new StringInputStream(String.valueOf(importStatements) + classifierCode);
                moduleFile.create((InputStream)classifierTextStream, true, null);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                String _message = e.getMessage();
                throw new WorkspaceWizardGeneratorException(_message);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Override
    public void performProjectDescriptionChanges(M model, IProgressMonitor monitor) throws WorkspaceWizardGeneratorException {
        boolean _greaterThan;
        URI moduleURI;
        List<IN4JSProject> referencedProjects;
        boolean _not;
        monitor.subTask("Performing project changes");
        Optional project = this.n4jsCore.findProject(URI.createPlatformResourceURI((String)((N4JSClassifierWizardModel)model).computeFileLocation().toString(), (boolean)true));
        boolean _isPresent = project.isPresent();
        boolean bl = _not = !_isPresent;
        if (_not) {
            throw new WorkspaceWizardGeneratorException("The target project couldn't be found.");
        }
        SafeURI projectDescriptionLocation = ((IN4JSProject)project.get()).getProjectDescriptionLocation();
        XtextResource projectDescriptionResource = this.generatorHelper.getResource(projectDescriptionLocation.toURI());
        List<IJSONDocumentModification> projectDescriptionModifications = this.generatorHelper.projectDescriptionModifications((Resource)projectDescriptionResource, (WorkspaceWizardModel)model, referencedProjects = this.getReferencedProjects(model), moduleURI = URI.createPlatformResourceURI((String)((N4JSClassifierWizardModel)model).computeFileLocation().toString(), (boolean)true));
        int _length = ((Object[])Conversions.unwrapArray(projectDescriptionModifications, Object.class)).length;
        boolean bl2 = _greaterThan = _length > 0;
        if (_greaterThan) {
            boolean _not_1;
            boolean _applyJSONModifications = this.generatorHelper.applyJSONModifications(projectDescriptionResource, projectDescriptionModifications);
            boolean bl3 = _not_1 = !_applyJSONModifications;
            if (_not_1) {
                throw new WorkspaceWizardGeneratorException("Couldn't apply package.json changes.");
            }
        }
    }

    protected abstract String generateClassifierCode(M var1, Map<URI, String> var2);

    protected abstract List<IN4JSProject> getReferencedProjects(M var1);

    protected abstract List<ImportRequirement> getImportRequirements(M var1);

    private void insertIntoFile(IFile file, M model) throws CoreException {
        boolean _notEquals;
        URI moduleURI = URI.createPlatformResourceURI((String)((N4JSClassifierWizardModel)model).computeFileLocation().toString(), (boolean)true);
        XtextResource moduleResource = this.generatorHelper.getResource(moduleURI);
        List<ImportRequirement> demandedImports = this.getImportRequirements(model);
        ImportAnalysis importAnalysis = this.requirementResolver.analyzeImportRequirements(demandedImports, moduleResource);
        String classCode = this.generateClassifierCode(model, importAnalysis.aliasBindings);
        String _lastCharacterInFile = this.generatorHelper.lastCharacterInFile(file);
        boolean bl = _notEquals = !Objects.equal((Object)_lastCharacterInFile, (Object)"\n");
        if (_notEquals) {
            classCode = "\n" + classCode;
        }
        StringInputStream classifierCodeStream = new StringInputStream(classCode);
        this.generatorHelper.insertImportStatements(moduleResource, importAnalysis.importRequirements);
        file.appendContents((InputStream)classifierCodeStream, true, true, null);
        this.generatorHelper.organizeImports(file, null);
    }
}

