/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.semver.model;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.semver.Semver.GitHubVersionRequirement;
import org.eclipse.n4js.semver.Semver.HyphenVersionRange;
import org.eclipse.n4js.semver.Semver.LocalPathVersionRequirement;
import org.eclipse.n4js.semver.Semver.Qualifier;
import org.eclipse.n4js.semver.Semver.QualifierTag;
import org.eclipse.n4js.semver.Semver.SemverToStringable;
import org.eclipse.n4js.semver.Semver.SimpleVersion;
import org.eclipse.n4js.semver.Semver.TagVersionRequirement;
import org.eclipse.n4js.semver.Semver.URLCommitISH;
import org.eclipse.n4js.semver.Semver.URLSemver;
import org.eclipse.n4js.semver.Semver.URLVersionRequirement;
import org.eclipse.n4js.semver.Semver.URLVersionSpecifier;
import org.eclipse.n4js.semver.Semver.VersionComparator;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.Semver.VersionPart;
import org.eclipse.n4js.semver.Semver.VersionRange;
import org.eclipse.n4js.semver.Semver.VersionRangeConstraint;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;

public class SemverSerializer
implements ISerializer {
    public static String serialize(URLVersionRequirement urlv) {
        if (urlv == null) {
            return "";
        }
        String str = "";
        if (urlv.getProtocol() != null) {
            str = String.valueOf(str) + urlv.getProtocol() + "://";
        }
        str = String.valueOf(str) + urlv.getUrl();
        if (urlv.getVersionSpecifier() != null) {
            str = String.valueOf(str) + "#" + SemverSerializer.serialize(urlv.getVersionSpecifier());
        }
        return str;
    }

    public static String serialize(URLVersionSpecifier urlvs) {
        if (urlvs instanceof URLCommitISH) {
            return SemverSerializer.serialize((URLCommitISH)urlvs);
        }
        if (urlvs instanceof URLSemver) {
            return SemverSerializer.serialize((URLSemver)urlvs);
        }
        return "";
    }

    public static String serialize(URLSemver urls) {
        if (urls == null) {
            return "";
        }
        String str = "";
        if (urls.isWithSemverTag()) {
            str = String.valueOf(str) + "semver:";
        }
        str = String.valueOf(str) + SemverSerializer.serialize(urls.getSimpleVersion());
        return str;
    }

    public static String serialize(URLCommitISH urlc) {
        if (urlc == null) {
            return "";
        }
        return urlc.getCommitISH();
    }

    public static String serialize(TagVersionRequirement tv) {
        if (tv == null) {
            return "";
        }
        return tv.getTagName();
    }

    public static String serialize(GitHubVersionRequirement ghv) {
        if (ghv == null) {
            return "";
        }
        String str = ghv.getGithubUrl();
        if (ghv.getCommitISH() != null) {
            str = String.valueOf(str) + "#" + ghv.getCommitISH();
        }
        return str;
    }

    public static String serialize(LocalPathVersionRequirement lpv) {
        if (lpv == null) {
            return "";
        }
        return "file:" + lpv.getLocalPath();
    }

    public static String serialize(VersionRangeSetRequirement vrs) {
        if (vrs == null) {
            return "";
        }
        String str = "";
        int i = 0;
        while (i < vrs.getRanges().size()) {
            if (i > 0) {
                str = String.valueOf(str) + " || ";
            }
            str = String.valueOf(str) + SemverSerializer.serialize((VersionRange)vrs.getRanges().get(i));
            ++i;
        }
        return str;
    }

    public static String serialize(VersionRange vr) {
        if (vr instanceof HyphenVersionRange) {
            return SemverSerializer.serialize((HyphenVersionRange)vr);
        }
        if (vr instanceof VersionRangeConstraint) {
            return SemverSerializer.serialize((VersionRangeConstraint)vr);
        }
        return "";
    }

    public static String serialize(HyphenVersionRange hvr) {
        if (hvr == null) {
            return "";
        }
        String str = String.valueOf(SemverSerializer.serialize(hvr.getFrom())) + " - " + SemverSerializer.serialize(hvr.getTo());
        return str;
    }

    public static String serialize(VersionRangeConstraint vrc) {
        if (vrc == null) {
            return "";
        }
        String str = "";
        int i = 0;
        while (i < vrc.getVersionConstraints().size()) {
            if (i > 0) {
                str = String.valueOf(str) + " ";
            }
            str = String.valueOf(str) + SemverSerializer.serialize((SimpleVersion)vrc.getVersionConstraints().get(i));
            ++i;
        }
        return str;
    }

    public static String serialize(SimpleVersion sv) {
        if (sv == null) {
            return "";
        }
        String str = "";
        for (VersionComparator vc : sv.getComparators()) {
            str = String.valueOf(str) + SemverSerializer.serialize(vc);
        }
        if (sv.isWithLetterV()) {
            str = String.valueOf(str) + "v";
        }
        str = String.valueOf(str) + SemverSerializer.serialize(sv.getNumber());
        return str;
    }

    public static String serialize(VersionNumber vn) {
        if (vn == null) {
            return "";
        }
        String str = SemverSerializer.serialize(vn.getMajor());
        if (vn.getMinor() != null) {
            str = String.valueOf(str) + "." + SemverSerializer.serialize(vn.getMinor());
        }
        if (vn.getPatch() != null) {
            str = String.valueOf(str) + "." + SemverSerializer.serialize(vn.getPatch());
        }
        for (VersionPart extend : vn.getExtended()) {
            str = String.valueOf(str) + "." + SemverSerializer.serialize(extend);
        }
        if (vn.getQualifier() != null) {
            str = String.valueOf(str) + SemverSerializer.serialize(vn.getQualifier());
        }
        return str;
    }

    public static String serialize(VersionPart vp) {
        if (vp == null) {
            return "";
        }
        String str = null;
        str = vp.isWildcard() ? "*" : String.valueOf(vp.getNumber());
        return str;
    }

    public static String serialize(Qualifier q) {
        if (q == null) {
            return "";
        }
        String str = "";
        if (q.getPreRelease() != null) {
            str = String.valueOf(str) + "-" + SemverSerializer.serialize(q.getPreRelease());
        }
        if (q.getBuildMetadata() != null) {
            str = String.valueOf(str) + "+" + SemverSerializer.serialize(q.getBuildMetadata());
        }
        return str;
    }

    public static String serialize(QualifierTag qt) {
        if (qt == null) {
            return "";
        }
        String str = Strings.concat((String)".", qt.getParts());
        return str;
    }

    public static String serialize(VersionComparator vc) {
        switch (vc) {
            case TILDE: {
                return "~";
            }
            case CARET: {
                return "^";
            }
            case EQUALS: {
                return "=";
            }
            case GREATER: {
                return ">";
            }
            case GREATER_EQUALS: {
                return ">=";
            }
            case SMALLER: {
                return "<";
            }
            case SMALLER_EQUALS: {
                return "<=";
            }
        }
        throw new UnsupportedOperationException();
    }

    public static String serialize(SemverToStringable obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof URLVersionRequirement) {
            return SemverSerializer.serialize((URLVersionRequirement)obj);
        }
        if (obj instanceof URLSemver) {
            return SemverSerializer.serialize((URLSemver)obj);
        }
        if (obj instanceof URLCommitISH) {
            return SemverSerializer.serialize((URLCommitISH)obj);
        }
        if (obj instanceof TagVersionRequirement) {
            return SemverSerializer.serialize((TagVersionRequirement)obj);
        }
        if (obj instanceof GitHubVersionRequirement) {
            return SemverSerializer.serialize((GitHubVersionRequirement)obj);
        }
        if (obj instanceof LocalPathVersionRequirement) {
            return SemverSerializer.serialize((LocalPathVersionRequirement)obj);
        }
        if (obj instanceof VersionRangeSetRequirement) {
            return SemverSerializer.serialize((VersionRangeSetRequirement)obj);
        }
        if (obj instanceof HyphenVersionRange) {
            return SemverSerializer.serialize((HyphenVersionRange)obj);
        }
        if (obj instanceof VersionRangeConstraint) {
            return SemverSerializer.serialize((VersionRangeConstraint)obj);
        }
        if (obj instanceof SimpleVersion) {
            return SemverSerializer.serialize((SimpleVersion)obj);
        }
        if (obj instanceof VersionNumber) {
            return SemverSerializer.serialize((VersionNumber)obj);
        }
        if (obj instanceof VersionPart) {
            return SemverSerializer.serialize((VersionPart)obj);
        }
        if (obj instanceof Qualifier) {
            return SemverSerializer.serialize((Qualifier)obj);
        }
        if (obj instanceof QualifierTag) {
            return SemverSerializer.serialize((QualifierTag)obj);
        }
        throw new UnsupportedOperationException("No serialize method found for type " + obj.getClass().getSimpleName());
    }

    public String serialize(EObject obj) {
        if (obj instanceof SemverToStringable) {
            return SemverSerializer.serialize((SemverToStringable)obj);
        }
        return null;
    }

    public String serialize(EObject obj, SaveOptions options) {
        return this.serialize(obj);
    }

    public void serialize(EObject obj, Writer writer, SaveOptions options) throws IOException {
        String serializedString = this.serialize(obj);
        writer.write(serializedString);
    }

    public ReplaceRegion serializeReplacement(EObject obj, SaveOptions options) {
        throw new UnsupportedOperationException();
    }
}

