/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.SingleRefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SinglePrototypeRefPair<S, T>
extends SingleRefPair<S, T> {
    public SinglePrototypeRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public String toString() {
        return "[SinglePrototypeRefPair: ref: [" + this.getRef() + "] service: [" + this.getServiceObject(null) + "]]";
    }

    @Override
    public boolean getServiceObject(ComponentContextImpl<S> key, BundleContext context) {
        Object service = key.getComponentServiceObjectsHelper().getPrototypeRefInstance(this.getRef());
        if (service == null) {
            this.setFailed();
            key.getLogger().log(2, "Could not get service from serviceobjects for ref {0}", null, this.getRef());
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            this.doUngetService(key, service);
        }
        return true;
    }

    @Override
    public T unsetServiceObject(ComponentContextImpl<S> key) {
        Object service = super.unsetServiceObject(key);
        if (service != null) {
            this.doUngetService(key, service);
        }
        return null;
    }

    private void doUngetService(ComponentContextImpl<S> key, T service) {
        try {
            key.getComponentServiceObjectsHelper().getServiceObjects(this.getRef()).ungetService(service);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

