/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.beans;

import com.google.common.base.Objects;
import org.eclipse.n4js.utils.beans.PropertyChangeSupport;
import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.ValidationContext;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class IgnorePropertyChangeEventsProcessor
extends AbstractFieldProcessor {
    public void doValidate(FieldDeclaration field, @Extension ValidationContext context) {
        TypeDeclaration clazz = field.getDeclaringType();
        Functions.Function1 _function = it -> {
            String _qualifiedName = it.getAnnotationTypeDeclaration().getQualifiedName();
            String _name = PropertyChangeSupport.class.getName();
            return Objects.equal((Object)_qualifiedName, (Object)_name);
        };
        Iterable annotations = IterableExtensions.filter((Iterable)clazz.getAnnotations(), (Functions.Function1)_function);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)annotations);
        if (_isNullOrEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Declaring type is not annotated with @");
            String _simpleName = PropertyChangeSupport.class.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(".");
            context.addError((Element)field, _builder.toString());
            return;
        }
        boolean _isStatic = field.isStatic();
        if (_isStatic) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Cannot enable property change support on static field.");
            context.addError((Element)field, _builder_1.toString());
            return;
        }
        boolean _isFinal = field.isFinal();
        if (_isFinal) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Cannot enable property change support on final field.");
            context.addError((Element)field, _builder_2.toString());
            return;
        }
        if (field.getType() != null && field.getType().isInferred()) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Cannot enable property change support on fields with inferred types.");
            context.addError((Element)field, _builder_3.toString());
            return;
        }
    }
}

