/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.ui.editor.model.DocumentUtil;

public class DocumentUtilN4
extends DocumentUtil {
    public static IRegion getLineInformationOfRegion(IDocument doc, int offset, int length, boolean includeLineDelimiterOfLastLine) throws BadLocationException {
        int firstLineNo = doc.getLineOfOffset(offset);
        int lastLineNo = doc.getLineOfOffset(offset + length);
        int startOffset = doc.getLineOffset(firstLineNo);
        int endOffset = doc.getLineOffset(lastLineNo) + (includeLineDelimiterOfLastLine ? doc.getLineLength(lastLineNo) : doc.getLineInformation(lastLineNo).getLength());
        return new Region(startOffset, endOffset - startOffset);
    }

    public static String getLine(IDocument doc, int offset) throws BadLocationException {
        IRegion reg = doc.getLineInformationOfOffset(offset);
        return doc.get(reg.getOffset(), reg.getLength());
    }

    public static String getIndent(IDocument doc, int offset) throws BadLocationException {
        return DocumentUtilN4.getIndent(doc, doc.getLineInformationOfOffset(offset));
    }

    public static String getIndent(IDocument doc, IRegion lineRegion) throws BadLocationException {
        String currLine = doc.get(lineRegion.getOffset(), lineRegion.getLength());
        int idx = 0;
        while (idx < currLine.length() && Character.isWhitespace(currLine.charAt(idx))) {
            ++idx;
        }
        return currLine.substring(0, idx);
    }
}

