/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Pair;

public class Collections2 {
    private Collections2() {
    }

    public static <T> LinkedList<T> newLinkedList(T ... initial) {
        return CollectionLiterals.newLinkedList((Object[])initial);
    }

    public static <T> ArrayList<T> newArrayList(T ... initial) {
        return CollectionLiterals.newArrayList((Object[])initial);
    }

    public static <T> HashSet<T> newHashSet(T ... initial) {
        return CollectionLiterals.newHashSet((Object[])initial);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... initial) {
        return CollectionLiterals.newLinkedHashSet((Object[])initial);
    }

    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator, T ... initial) {
        return CollectionLiterals.newTreeSet(comparator, (Object[])initial);
    }

    public static <K, V> HashMap<K, V> newHashMap(Pair<? extends K, ? extends V> ... initial) {
        return CollectionLiterals.newHashMap(initial);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Pair<? extends K, ? extends V> ... initial) {
        return CollectionLiterals.newLinkedHashMap(initial);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator, Pair<? extends K, ? extends V> ... initial) {
        return CollectionLiterals.newTreeMap(comparator, initial);
    }

    public static <T> List<T> concatUnique(List<T> listA, List<T> listB) {
        Objects.requireNonNull(listA);
        Objects.requireNonNull(listB);
        LinkedHashSet<Object> result = Collections2.newLinkedHashSet((Object[])Conversions.unwrapArray(listA, Object.class));
        result.addAll(listB);
        return Collections2.newLinkedList((Object[])Conversions.unwrapArray(result, Object.class));
    }

    public static <T> Stream<Pair<T, T>> pairs(Collection<T> collection) {
        Function<Object, Stream> _function = e1 -> {
            Function<Object, Pair> _function_1 = e2 -> Pair.of((Object)e1, (Object)e2);
            return collection.stream().map(_function_1);
        };
        return collection.stream().flatMap(_function);
    }
}

