/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.ASTUtils;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ListUtils;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;

class ForFactory {
    ForFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ForStatement forStmt) {
        if (forStmt.isForIn()) {
            return ForFactory.buildForInOf(astpp, forStmt, true);
        }
        if (forStmt.isForOf()) {
            return ForFactory.buildForInOf(astpp, forStmt, false);
        }
        if (forStmt.isForPlain()) {
            return ForFactory.buildForPlain(astpp, forStmt);
        }
        return null;
    }

    private static ComplexNode buildForInOf(ReentrantASTIterator astpp, ForStatement forStmt, boolean forInSemantics) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)forStmt);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)forStmt);
        LinkedList<DelegatingNode> declNodes = new LinkedList<DelegatingNode>();
        LinkedList<DelegatingNode> initNodes = new LinkedList<DelegatingNode>();
        if (forStmt.getVarDeclsOrBindings() != null) {
            int i = 0;
            for (VariableDeclarationOrBinding vdob : forStmt.getVarDeclsOrBindings()) {
                DelegatingNode initNode = DelegatingNodeFactory.create(astpp, "decl_" + i, (ControlFlowElement)forStmt, (ControlFlowElement)vdob);
                declNodes.add(initNode);
                ++i;
            }
        }
        if (forStmt.getInitExpr() != null) {
            DelegatingNode initNode = DelegatingNodeFactory.create(astpp, "inits", (ControlFlowElement)forStmt, (ControlFlowElement)forStmt.getInitExpr());
            initNodes.add(initNode);
        }
        DelegatingNode expressionNode = DelegatingNodeFactory.create(astpp, "expression", (ControlFlowElement)forStmt, (ControlFlowElement)forStmt.getExpression());
        HelperNode getObjectKeysNode = null;
        if (forInSemantics) {
            getObjectKeysNode = new HelperNode("getObjectKeys", astpp.pos(), (ControlFlowElement)forStmt);
        }
        HelperNode getIteratorNode = new HelperNode("getIterator", astpp.pos(), (ControlFlowElement)forStmt);
        HelperNode hasNextNode = new HelperNode("hasNext", astpp.pos(), (ControlFlowElement)forStmt);
        HelperNode nextNode = new HelperNode("next", astpp.pos(), (ControlFlowElement)forStmt);
        Node bodyNode = DelegatingNodeFactory.createOrHelper(astpp, "body", (ControlFlowElement)forStmt, (ControlFlowElement)forStmt.getStatement());
        HelperNode continueCatchNode = new HelperNode("continueCatch", astpp.pos(), (ControlFlowElement)forStmt);
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)forStmt);
        cNode.addNode(entryNode);
        for (Node node : declNodes) {
            cNode.addNode(node);
        }
        for (Node node : initNodes) {
            cNode.addNode(node);
        }
        cNode.addNode(expressionNode);
        cNode.addNode(getObjectKeysNode);
        cNode.addNode(getIteratorNode);
        cNode.addNode(hasNextNode);
        cNode.addNode(nextNode);
        cNode.addNode(bodyNode);
        cNode.addNode(continueCatchNode);
        cNode.addNode(exitNode);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(entryNode);
        linkedList.addAll(declNodes);
        linkedList.addAll(initNodes);
        linkedList.add(expressionNode);
        linkedList.add(getObjectKeysNode);
        linkedList.add(getIteratorNode);
        linkedList.add(hasNextNode);
        cNode.connectInternalSucc(linkedList);
        cNode.connectInternalSucc(ControlFlowType.LoopExit, hasNextNode, exitNode);
        cNode.connectInternalSucc(ControlFlowType.LoopEnter, hasNextNode, nextNode);
        cNode.connectInternalSucc(nextNode, bodyNode, continueCatchNode);
        cNode.connectInternalSucc(ControlFlowType.LoopRepeat, continueCatchNode, hasNextNode);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        LabelledStatement lblStmt = ASTUtils.getLabelledStatement((Statement)forStmt);
        exitNode.addCatchToken(new CatchToken(ControlFlowType.Break, lblStmt));
        continueCatchNode.addCatchToken(new CatchToken(ControlFlowType.Continue, lblStmt));
        return cNode;
    }

    private static ComplexNode buildForPlain(ReentrantASTIterator astpp, ForStatement forStmt) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)forStmt);
        LinkedList<DelegatingNode> initNodes = new LinkedList<DelegatingNode>();
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)forStmt);
        DelegatingNode conditionNode = null;
        Node bodyNode = null;
        DelegatingNode updatesNode = null;
        if (forStmt.getVarDeclsOrBindings() != null) {
            int i = 0;
            for (VariableDeclarationOrBinding vdob : forStmt.getVarDeclsOrBindings()) {
                Node initNode = DelegatingNodeFactory.create(astpp, "init_" + i, (ControlFlowElement)forStmt, (ControlFlowElement)vdob);
                initNodes.add((DelegatingNode)initNode);
                ++i;
            }
        }
        if (forStmt.getInitExpr() != null) {
            DelegatingNode initNode = DelegatingNodeFactory.create(astpp, "inits", (ControlFlowElement)forStmt, (ControlFlowElement)forStmt.getInitExpr());
            initNodes.add(initNode);
        }
        if (forStmt.getExpression() != null) {
            conditionNode = DelegatingNodeFactory.create(astpp, "condition", (ControlFlowElement)forStmt, (ControlFlowElement)forStmt.getExpression());
        }
        HelperNode conditionForkNode = new HelperNode("conditionFork", astpp.pos(), (ControlFlowElement)forStmt);
        bodyNode = DelegatingNodeFactory.createOrHelper(astpp, "body", (ControlFlowElement)forStmt, (ControlFlowElement)forStmt.getStatement());
        HelperNode continueCatchNode = new HelperNode("continueCatch", astpp.pos(), (ControlFlowElement)forStmt);
        if (forStmt.getUpdateExpr() != null) {
            updatesNode = DelegatingNodeFactory.create(astpp, "updates", (ControlFlowElement)forStmt, (ControlFlowElement)forStmt.getUpdateExpr());
        }
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)forStmt);
        cNode.addNode(entryNode);
        cNode.addNode(exitNode);
        for (Node initNode : initNodes) {
            cNode.addNode(initNode);
        }
        cNode.addNode(conditionNode);
        cNode.addNode(conditionForkNode);
        cNode.addNode(bodyNode);
        cNode.addNode(continueCatchNode);
        cNode.addNode(updatesNode);
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(entryNode);
        nodes.addAll(initNodes);
        nodes.add(conditionNode);
        nodes.add(conditionForkNode);
        cNode.connectInternalSucc(nodes);
        cNode.connectInternalSucc(ControlFlowType.LoopEnter, conditionForkNode, bodyNode);
        if (conditionNode != null) {
            cNode.connectInternalSucc(ControlFlowType.LoopExit, conditionForkNode, exitNode);
            cNode.connectInternalSucc(bodyNode, continueCatchNode, updatesNode);
            Node beforeConditionNode = ListUtils.filterNulls(bodyNode, continueCatchNode, updatesNode).getLast();
            cNode.connectInternalSucc(ControlFlowType.LoopRepeat, beforeConditionNode, conditionNode);
        } else {
            cNode.connectInternalSucc(bodyNode, continueCatchNode, updatesNode);
            LinkedList<Node> loopCycle = ListUtils.filterNulls(continueCatchNode, updatesNode);
            Node loopSrc = loopCycle.getLast();
            cNode.connectInternalSucc(ControlFlowType.LoopInfinite, loopSrc, conditionForkNode);
            cNode.connectInternalSucc(ControlFlowType.DeadCode, loopSrc, exitNode);
        }
        bodyNode.addCatchToken(new CatchToken(ControlFlowType.IfTrue, ControlFlowType.LoopEnter));
        exitNode.addCatchToken(new CatchToken(ControlFlowType.IfFalse, ControlFlowType.LoopExit));
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        LabelledStatement lblStmt = ASTUtils.getLabelledStatement((Statement)forStmt);
        exitNode.addCatchToken(new CatchToken(ControlFlowType.Break, lblStmt));
        continueCatchNode.addCatchToken(new CatchToken(ControlFlowType.Continue, lblStmt));
        return cNode;
    }
}

